"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGettingStartedRoutes = registerGettingStartedRoutes;
var _configSchema = require("@osd/config-schema");
var _stream = require("stream");
var _utils = require("../../../../../src/core/server/saved_objects/routes/utils");
var _helper = require("./helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerGettingStartedRoutes(router) {
  // Fetch the tutorial assets
  router.get({
    path: `/api/observability/gettingStarted/{tutorialId}`,
    validate: {
      params: _configSchema.schema.object({
        tutorialId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const fileData = await (0, _helper.loadAssetsFromFile)(request.params.tutorialId);
      return response.ok({
        body: {
          data: fileData
        }
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: 'Issue in fetching NDJSON file for tutorialId: ' + request.params.tutorialId
      });
    }
  });

  // Fetch the tutorial dashboards
  router.get({
    path: `/api/observability/gettingStarted/dashboards/{tutorialId}`,
    validate: {
      params: _configSchema.schema.object({
        tutorialId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const fileData = await (0, _helper.loadAssetsFromFile)(request.params.tutorialId);
      const objects = await (0, _utils.createSavedObjectsStreamFromNdJson)(_stream.Readable.from(fileData));
      const loadedObjects = await objects.toArray();
      const loadDashboardIds = loadedObjects.filter(savedObject => savedObject.type === 'dashboard').map(dashboard => ({
        id: dashboard.id,
        title: dashboard.attributes.title
      }));
      return response.ok({
        body: {
          data: loadDashboardIds
        }
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: 'Issue in fetching dashboards for tutorialId: ' + request.params.tutorialId
      });
    }
  });

  // Fetch the tutorial saved searches
  router.get({
    path: `/api/observability/gettingStarted/indexPatterns/{tutorialId}`,
    validate: {
      params: _configSchema.schema.object({
        tutorialId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const fileData = await (0, _helper.loadAssetsFromFile)(request.params.tutorialId);
      const objects = await (0, _utils.createSavedObjectsStreamFromNdJson)(_stream.Readable.from(fileData));
      const loadedObjects = await objects.toArray();
      const loadDashboardIds = loadedObjects.filter(savedObject => savedObject.type === 'index-pattern').map(indexPattern => ({
        id: indexPattern.id,
        title: indexPattern.attributes.title
      }));
      return response.ok({
        body: {
          data: loadDashboardIds
        }
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: 'Issue in fetching index-patterns for tutorialId: ' + request.params.tutorialId
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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