"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_PREFIX_DICT = exports.TRIGGER_TYPE_DICT = exports.REPORT_STATE_DICT = exports.REPORT_SOURCE_DICT = exports.REPORT_FORMAT_DICT = exports.BACKEND_TRIGGER_TYPE = exports.BACKEND_REPORT_STATE = exports.BACKEND_REPORT_SOURCE = exports.BACKEND_REPORT_FORMAT = exports.BACKEND_DELIVERY_FORMAT = void 0;
var _constants = require("../routes/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let BACKEND_DELIVERY_FORMAT = exports.BACKEND_DELIVERY_FORMAT = /*#__PURE__*/function (BACKEND_DELIVERY_FORMAT) {
  BACKEND_DELIVERY_FORMAT["linkOnly"] = "LinkOnly";
  BACKEND_DELIVERY_FORMAT["attachment"] = "Attachment";
  BACKEND_DELIVERY_FORMAT["embedded"] = "Embedded";
  return BACKEND_DELIVERY_FORMAT;
}({});
let BACKEND_REPORT_SOURCE = exports.BACKEND_REPORT_SOURCE = /*#__PURE__*/function (BACKEND_REPORT_SOURCE) {
  BACKEND_REPORT_SOURCE["dashboard"] = "Dashboard";
  BACKEND_REPORT_SOURCE["visualization"] = "Visualization";
  BACKEND_REPORT_SOURCE["savedSearch"] = "SavedSearch";
  BACKEND_REPORT_SOURCE["notebook"] = "Notebook";
  return BACKEND_REPORT_SOURCE;
}({});
let BACKEND_REPORT_STATE = exports.BACKEND_REPORT_STATE = /*#__PURE__*/function (BACKEND_REPORT_STATE) {
  BACKEND_REPORT_STATE["scheduled"] = "Scheduled";
  BACKEND_REPORT_STATE["executing"] = "Executing";
  BACKEND_REPORT_STATE["success"] = "Success";
  BACKEND_REPORT_STATE["failed"] = "Failed";
  return BACKEND_REPORT_STATE;
}({});
let BACKEND_REPORT_FORMAT = exports.BACKEND_REPORT_FORMAT = /*#__PURE__*/function (BACKEND_REPORT_FORMAT) {
  BACKEND_REPORT_FORMAT["pdf"] = "Pdf";
  BACKEND_REPORT_FORMAT["png"] = "Png";
  BACKEND_REPORT_FORMAT["csv"] = "Csv";
  BACKEND_REPORT_FORMAT["xlsx"] = "Xlsx";
  return BACKEND_REPORT_FORMAT;
}({});
let BACKEND_TRIGGER_TYPE = exports.BACKEND_TRIGGER_TYPE = /*#__PURE__*/function (BACKEND_TRIGGER_TYPE) {
  BACKEND_TRIGGER_TYPE["download"] = "Download";
  BACKEND_TRIGGER_TYPE["onDemand"] = "OnDemand";
  BACKEND_TRIGGER_TYPE["cronSchedule"] = "CronSchedule";
  BACKEND_TRIGGER_TYPE["intervalSchedule"] = "IntervalSchedule";
  return BACKEND_TRIGGER_TYPE;
}({});
const REPORT_STATE_DICT = exports.REPORT_STATE_DICT = {
  [_constants.REPORT_STATE.pending]: BACKEND_REPORT_STATE.executing,
  [_constants.REPORT_STATE.error]: BACKEND_REPORT_STATE.failed,
  [_constants.REPORT_STATE.shared]: BACKEND_REPORT_STATE.success,
  [_constants.REPORT_STATE.created]: BACKEND_REPORT_STATE.success
};
const REPORT_SOURCE_DICT = exports.REPORT_SOURCE_DICT = {
  [_constants.REPORT_TYPE.dashboard]: BACKEND_REPORT_SOURCE.dashboard,
  [_constants.REPORT_TYPE.visualization]: BACKEND_REPORT_SOURCE.visualization,
  [_constants.REPORT_TYPE.savedSearch]: BACKEND_REPORT_SOURCE.savedSearch,
  [_constants.REPORT_TYPE.notebook]: BACKEND_REPORT_SOURCE.notebook
};
const REPORT_FORMAT_DICT = exports.REPORT_FORMAT_DICT = {
  [_constants.FORMAT.csv]: BACKEND_REPORT_FORMAT.csv,
  [_constants.FORMAT.xlsx]: BACKEND_REPORT_FORMAT.xlsx,
  [_constants.FORMAT.pdf]: BACKEND_REPORT_FORMAT.pdf,
  [_constants.FORMAT.png]: BACKEND_REPORT_FORMAT.png
};
const TRIGGER_TYPE_DICT = exports.TRIGGER_TYPE_DICT = {
  [_constants.TRIGGER_TYPE.schedule]: [BACKEND_TRIGGER_TYPE.cronSchedule, BACKEND_TRIGGER_TYPE.intervalSchedule],
  [_constants.TRIGGER_TYPE.onDemand]: [BACKEND_TRIGGER_TYPE.onDemand, BACKEND_TRIGGER_TYPE.download]
};
const URL_PREFIX_DICT = exports.URL_PREFIX_DICT = {
  [BACKEND_REPORT_SOURCE.dashboard]: '/app/dashboards#/view/',
  [BACKEND_REPORT_SOURCE.savedSearch]: '/app/discover#/view/',
  [BACKEND_REPORT_SOURCE.visualization]: '/app/visualize#/edit/',
  [BACKEND_REPORT_SOURCE.notebook]: '/app/notebooks-dashboards?view=output_only#/'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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