/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 0ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 3ul) => u64vec4(495ul, 399ul, 579ul, 228ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 1192ul) => u64vec4(196680ul, 158536ul, 230056ul, 90592ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 1048576ul) => u64vec4(173015040ul, 139460608ul, 202375168ul, 79691776ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 4251475ul) => u64vec4(701493375ul, 565446175ul, 820534675ul, 323112100ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 29852643761ul) => u64vec4(4925686220565ul, 3970401620213ul, 5761560245873ul, 2268800925836ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 4398046511104ul) => u64vec4(725677674332160ul, 584940185976832ul, 848822976643072ul, 334251534843904ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 3948976685146ul) => u64vec4(651581153049090ul, 525213899124418ul, 762152500233178ul, 300122228071096ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 135763469567146206ul) => u64vec4(3954228404869572374ul, 18056541452430445398ul, 7755605552749666142ul, 10318023687103111656ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) * 11654173250180970009ul) => u64vec4(4477202614066683421ul, 478540082466675453ul, 17199404366071466201ul, 273451475695243116ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 0ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 3ul) => u64vec4(240ul, 45ul, 153ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 1192ul) => u64vec4(95360ul, 17880ul, 60792ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 1048576ul) => u64vec4(83886080ul, 15728640ul, 53477376ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 4251475ul) => u64vec4(340118000ul, 63772125ul, 216825225ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 29852643761ul) => u64vec4(2388211500880ul, 447789656415ul, 1522484831811ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 4398046511104ul) => u64vec4(351843720888320ul, 65970697666560ul, 224300372066304ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 3948976685146ul) => u64vec4(315918134811680ul, 59234650277190ul, 201397810942446ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 135763469567146206ul) => u64vec4(10861077565371696480ul, 2036452043507193090ul, 6923936947924456506ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) * 11654173250180970009ul) => u64vec4(9996656329000019920ul, 8791902089328585591ul, 4067025400523818747ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 0ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 3ul), u64vec4(495ul, 399ul, 579ul, 228ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 1192ul), u64vec4(196680ul, 158536ul, 230056ul, 90592ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 1048576ul), u64vec4(173015040ul, 139460608ul, 202375168ul, 79691776ul))) ? 1 : -1] array3;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 4251475ul), u64vec4(701493375ul, 565446175ul, 820534675ul, 323112100ul))) ? 1 : -1] array4;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 29852643761ul), u64vec4(4925686220565ul, 3970401620213ul, 5761560245873ul, 2268800925836ul))) ? 1 : -1] array5;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 4398046511104ul), u64vec4(725677674332160ul, 584940185976832ul, 848822976643072ul, 334251534843904ul))) ? 1 : -1] array6;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 3948976685146ul), u64vec4(651581153049090ul, 525213899124418ul, 762152500233178ul, 300122228071096ul))) ? 1 : -1] array7;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 135763469567146206ul), u64vec4(3954228404869572374ul, 18056541452430445398ul, 7755605552749666142ul, 10318023687103111656ul))) ? 1 : -1] array8;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) * 11654173250180970009ul), u64vec4(4477202614066683421ul, 478540082466675453ul, 17199404366071466201ul, 273451475695243116ul))) ? 1 : -1] array9;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 0ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 3ul), u64vec4(240ul, 45ul, 153ul, 0ul))) ? 1 : -1] array11;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 1192ul), u64vec4(95360ul, 17880ul, 60792ul, 0ul))) ? 1 : -1] array12;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 1048576ul), u64vec4(83886080ul, 15728640ul, 53477376ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 4251475ul), u64vec4(340118000ul, 63772125ul, 216825225ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 29852643761ul), u64vec4(2388211500880ul, 447789656415ul, 1522484831811ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 4398046511104ul), u64vec4(351843720888320ul, 65970697666560ul, 224300372066304ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 3948976685146ul), u64vec4(315918134811680ul, 59234650277190ul, 201397810942446ul, 0ul))) ? 1 : -1] array17;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 135763469567146206ul), u64vec4(10861077565371696480ul, 2036452043507193090ul, 6923936947924456506ul, 0ul))) ? 1 : -1] array18;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) * 11654173250180970009ul), u64vec4(9996656329000019920ul, 8791902089328585591ul, 4067025400523818747ul, 0ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
