/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssBackgroundClip;
import org.w3c.css.properties.css3.CssBackgroundPosition;
import org.w3c.css.properties.css3.CssBorderRadius;
import org.w3c.css.properties.svg.CssFillRule;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssClipPath
extends org.w3c.css.properties.css.CssClipPath {
    public static final CssIdent[] geometry_box_allowed_values;
    public static final CssIdent[] shape_radius_allowed_values;
    public static final CssIdent inset_round;
    public static final CssIdent at_position;

    public static final CssIdent getGeometryBoxAllowedValue(CssIdent ident) {
        CssIdent idt = CssBackgroundClip.getMatchingIdent(ident);
        if (idt != null) {
            return idt;
        }
        for (CssIdent id : geometry_box_allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getShapeRadiusAllowedValue(CssIdent ident) {
        for (CssIdent id : shape_radius_allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssClipPath() {
        this.value = initial;
    }

    public CssClipPath(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean gotGeometryBox = false;
        boolean gotBasicShape = false;
        while (!expression.end()) {
            char op = expression.getOperator();
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 11: {
                    if (!gotBasicShape) {
                        String funcname;
                        CssFunction func = val.getFunction();
                        switch (funcname = func.getName().toLowerCase()) {
                            case "inset": {
                                CssClipPath.checkInsetFunction(ac, func.getParameters(), this);
                                break;
                            }
                            case "circle": {
                                CssClipPath.checkCircleFunction(ac, func.getParameters(), this);
                                break;
                            }
                            case "ellipse": {
                                CssClipPath.checkEllipseFunction(ac, func.getParameters(), this);
                                break;
                            }
                            case "polygon": {
                                CssClipPath.checkPolygonFunction(ac, func.getParameters(), this);
                                break;
                            }
                            default: {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                        }
                        gotBasicShape = true;
                        values.add(val);
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                case 2: {
                    this.value = val;
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        this.value = val;
                        break;
                    }
                    if (none.equals(id)) {
                        this.value = val;
                        break;
                    }
                    if (!gotGeometryBox && CssClipPath.getGeometryBoxAllowedValue(id) != null) {
                        gotGeometryBox = true;
                        values.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (gotBasicShape || gotGeometryBox) {
            this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
    }

    public CssClipPath(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    protected static void checkInsetFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        int nb_shape_arg = 0;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    if (++nb_shape_arg <= 4) break;
                    throw new InvalidParamException("unrecognize", ac);
                }
                case 0: {
                    if (inset_round.equals(val.getIdent())) {
                        CssExpression nex = new CssExpression();
                        expression.next();
                        while (!expression.end()) {
                            nex.addValue(expression.getValue());
                            nex.setOperator(expression.getOperator());
                            expression.next();
                        }
                        if (nex.getCount() == 0) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        CssBorderRadius.parseBorderCornerRadius(ac, nex, true, caller);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
    }

    protected static void checkCircleFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        boolean gotRadius = false;
        if (expression == null || expression.getCount() == 0) {
            return;
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    if (gotRadius) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    val.getCheckableValue().checkPositiveness(ac, caller);
                    gotRadius = true;
                    break;
                }
                case 0: {
                    CssIdent ident = val.getIdent();
                    if (CssClipPath.getShapeRadiusAllowedValue(ident) != null) {
                        if (gotRadius) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        gotRadius = true;
                        break;
                    }
                    if (at_position.equals(ident)) {
                        CssExpression nex = new CssExpression();
                        expression.next();
                        while (!expression.end()) {
                            nex.addValue(expression.getValue());
                            nex.setOperator(expression.getOperator());
                            expression.next();
                        }
                        if (nex.getCount() == 0) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        CssBackgroundPosition.checkSyntax(ac, nex, caller.getPropertyName());
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
    }

    protected static void checkEllipseFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        int nbRadius = 0;
        if (expression == null || expression.getCount() == 0) {
            return;
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    if (nbRadius >= 2) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    val.getCheckableValue().checkPositiveness(ac, caller);
                    ++nbRadius;
                    break;
                }
                case 0: {
                    CssIdent ident = val.getIdent();
                    if (CssClipPath.getShapeRadiusAllowedValue(ident) != null) {
                        if (nbRadius >= 2) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        ++nbRadius;
                        break;
                    }
                    if (at_position.equals(ident)) {
                        CssExpression nex = new CssExpression();
                        expression.next();
                        while (!expression.end()) {
                            nex.addValue(expression.getValue());
                            nex.setOperator(expression.getOperator());
                            expression.next();
                        }
                        if (nex.getCount() == 0) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        CssBackgroundPosition.checkSyntax(ac, nex, caller.getPropertyName());
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
    }

    protected static void checkPolygonFunction(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        int nbShapeArgs = 0;
        int nbPoints = 0;
        boolean gotFillRule = false;
        if (expression == null || expression.getCount() == 0) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    if (nbShapeArgs >= 2) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    ++nbShapeArgs;
                    break;
                }
                case 0: {
                    if (!gotFillRule && nbPoints == 0 && nbShapeArgs == 0 && CssFillRule.getAllowedIdent(val.getIdent()) != null) {
                        gotFillRule = true;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            if (gotFillRule && nbPoints == 0 && nbShapeArgs == 0) {
                if (op != ',') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
            } else if (nbShapeArgs == 2) {
                if (expression.getRemainingCount() > 1 && op != ',') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                ++nbPoints;
                nbShapeArgs = 0;
            } else if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (nbShapeArgs == 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
    }

    static {
        String[] _allowed_values = new String[]{"margin-box", "fill-box", "stroke-box", "view-box"};
        geometry_box_allowed_values = new CssIdent[_allowed_values.length];
        for (int i = 0; i < geometry_box_allowed_values.length; ++i) {
            CssClipPath.geometry_box_allowed_values[i] = CssIdent.getIdent(_allowed_values[i]);
        }
        String[] _shape_radius_values = new String[]{"closest-side", "farthest-side"};
        shape_radius_allowed_values = new CssIdent[_shape_radius_values.length];
        for (int i = 0; i < _shape_radius_values.length; ++i) {
            CssClipPath.shape_radius_allowed_values[i] = CssIdent.getIdent(_shape_radius_values[i]);
        }
        inset_round = CssIdent.getIdent("round");
        at_position = CssIdent.getIdent("at");
    }
}

