"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerQueryRoute = registerQueryRoute;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerQueryRoute(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_JSON,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLJson(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_JSON,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLJson(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SPARK_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncGetQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    return response.ok({
      body: retVal
    });
  });
  server.delete({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeAsyncDeleteQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: `${_constants.ROUTE_PATH_GET_DATASOURCES}/{dataSourceMDSId?}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSyncQueryDataSources(context, request);
    return response.ok({
      body: retVal
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9jb25zdGFudHMiLCJyZWdpc3RlclF1ZXJ5Um91dGUiLCJzZXJ2ZXIiLCJzZXJ2aWNlIiwicG9zdCIsInBhdGgiLCJST1VURV9QQVRIX1NRTF9RVUVSWSIsInZhbGlkYXRlIiwiYm9keSIsInNjaGVtYSIsImFueSIsInF1ZXJ5Iiwib2JqZWN0IiwiZGF0YVNvdXJjZU1EU0lkIiwibWF5YmUiLCJzdHJpbmciLCJkZWZhdWx0VmFsdWUiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwicmV0VmFsIiwiZGVzY3JpYmVTUUxRdWVyeSIsIm9rIiwiUk9VVEVfUEFUSF9QUExfUVVFUlkiLCJkZXNjcmliZVBQTFF1ZXJ5IiwiUk9VVEVfUEFUSF9TUUxfQ1NWIiwiZGVzY3JpYmVTUUxDc3YiLCJST1VURV9QQVRIX1BQTF9DU1YiLCJkZXNjcmliZVBQTENzdiIsIlJPVVRFX1BBVEhfU1FMX0pTT04iLCJkZXNjcmliZVNRTEpzb24iLCJST1VURV9QQVRIX1BQTF9KU09OIiwiZGVzY3JpYmVQUExKc29uIiwiUk9VVEVfUEFUSF9TUUxfVEVYVCIsImRlc2NyaWJlU1FMVGV4dCIsIlJPVVRFX1BBVEhfUFBMX1RFWFQiLCJkZXNjcmliZVBQTFRleHQiLCJST1VURV9QQVRIX1NQQVJLX1NRTF9RVUVSWSIsImRlc2NyaWJlU1FMQXN5bmNRdWVyeSIsImdldCIsIlJPVVRFX1BBVEhfU1BBUktfU1FMX0pPQl9RVUVSWSIsInBhcmFtcyIsImlkIiwiZGVzY3JpYmVTUUxBc3luY0dldFF1ZXJ5IiwiZGVsZXRlIiwiZGVzY3JpYmVBc3luY0RlbGV0ZVF1ZXJ5IiwiUk9VVEVfUEFUSF9HRVRfREFUQVNPVVJDRVMiLCJkZXNjcmliZVN5bmNRdWVyeURhdGFTb3VyY2VzIl0sInNvdXJjZXMiOlsicXVlcnkudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2UsIElSb3V0ZXIsIFJlc3BvbnNlRXJyb3IgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IFF1ZXJ5U2VydmljZSBmcm9tICcuLi9zZXJ2aWNlcy9RdWVyeVNlcnZpY2UnO1xuaW1wb3J0IHtcbiAgUk9VVEVfUEFUSF9HRVRfREFUQVNPVVJDRVMsXG4gIFJPVVRFX1BBVEhfUFBMX0NTVixcbiAgUk9VVEVfUEFUSF9QUExfSlNPTixcbiAgUk9VVEVfUEFUSF9QUExfUVVFUlksXG4gIFJPVVRFX1BBVEhfUFBMX1RFWFQsXG4gIFJPVVRFX1BBVEhfU1BBUktfU1FMX0pPQl9RVUVSWSxcbiAgUk9VVEVfUEFUSF9TUEFSS19TUUxfUVVFUlksXG4gIFJPVVRFX1BBVEhfU1FMX0NTVixcbiAgUk9VVEVfUEFUSF9TUUxfSlNPTixcbiAgUk9VVEVfUEFUSF9TUUxfUVVFUlksXG4gIFJPVVRFX1BBVEhfU1FMX1RFWFQsXG59IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWdpc3RlclF1ZXJ5Um91dGUoc2VydmVyOiBJUm91dGVyLCBzZXJ2aWNlOiBRdWVyeVNlcnZpY2UpIHtcbiAgc2VydmVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogUk9VVEVfUEFUSF9TUUxfUVVFUlksXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlU1FMUXVlcnkoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICBib2R5OiByZXRWYWwsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG5cbiAgc2VydmVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogUk9VVEVfUEFUSF9QUExfUVVFUlksXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlUFBMUXVlcnkoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICBib2R5OiByZXRWYWwsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG5cbiAgc2VydmVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogUk9VVEVfUEFUSF9TUUxfQ1NWLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgZGF0YVNvdXJjZU1EU0lkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogJycgfSkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoXG4gICAgICBjb250ZXh0LFxuICAgICAgcmVxdWVzdCxcbiAgICAgIHJlc3BvbnNlXG4gICAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3QgcmV0VmFsID0gYXdhaXQgc2VydmljZS5kZXNjcmliZVNRTENzdihjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHk6IHJldFZhbCxcbiAgICAgIH0pO1xuICAgIH1cbiAgKTtcblxuICBzZXJ2ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBST1VURV9QQVRIX1BQTF9DU1YsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlUFBMQ3N2KGNvbnRleHQsIHJlcXVlc3QpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLm9rKHtcbiAgICAgICAgYm9keTogcmV0VmFsLFxuICAgICAgfSk7XG4gICAgfVxuICApO1xuXG4gIHNlcnZlci5wb3N0KFxuICAgIHtcbiAgICAgIHBhdGg6IFJPVVRFX1BBVEhfU1FMX0pTT04sXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlU1FMSnNvbihjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHk6IHJldFZhbCxcbiAgICAgIH0pO1xuICAgIH1cbiAgKTtcblxuICBzZXJ2ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBST1VURV9QQVRIX1BQTF9KU09OLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgZGF0YVNvdXJjZU1EU0lkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogJycgfSkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoXG4gICAgICBjb250ZXh0LFxuICAgICAgcmVxdWVzdCxcbiAgICAgIHJlc3BvbnNlXG4gICAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3QgcmV0VmFsID0gYXdhaXQgc2VydmljZS5kZXNjcmliZVBQTEpzb24oY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICBib2R5OiByZXRWYWwsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG5cbiAgc2VydmVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogUk9VVEVfUEFUSF9TUUxfVEVYVCxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRhdGFTb3VyY2VNRFNJZDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoeyBkZWZhdWx0VmFsdWU6ICcnIH0pKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgYXN5bmMgKFxuICAgICAgY29udGV4dCxcbiAgICAgIHJlcXVlc3QsXG4gICAgICByZXNwb25zZVxuICAgICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHJldFZhbCA9IGF3YWl0IHNlcnZpY2UuZGVzY3JpYmVTUUxUZXh0KGNvbnRleHQsIHJlcXVlc3QpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLm9rKHtcbiAgICAgICAgYm9keTogcmV0VmFsLFxuICAgICAgfSk7XG4gICAgfVxuICApO1xuXG4gIHNlcnZlci5wb3N0KFxuICAgIHtcbiAgICAgIHBhdGg6IFJPVVRFX1BBVEhfUFBMX1RFWFQsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlUFBMVGV4dChjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHk6IHJldFZhbCxcbiAgICAgIH0pO1xuICAgIH1cbiAgKTtcblxuICBzZXJ2ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBST1VURV9QQVRIX1NQQVJLX1NRTF9RVUVSWSxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRhdGFTb3VyY2VNRFNJZDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoeyBkZWZhdWx0VmFsdWU6ICcnIH0pKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgYXN5bmMgKFxuICAgICAgY29udGV4dCxcbiAgICAgIHJlcXVlc3QsXG4gICAgICByZXNwb25zZVxuICAgICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHJldFZhbCA9IGF3YWl0IHNlcnZpY2UuZGVzY3JpYmVTUUxBc3luY1F1ZXJ5KGNvbnRleHQsIHJlcXVlc3QpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLm9rKHtcbiAgICAgICAgYm9keTogcmV0VmFsLFxuICAgICAgfSk7XG4gICAgfVxuICApO1xuXG4gIHNlcnZlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogUk9VVEVfUEFUSF9TUEFSS19TUUxfSk9CX1FVRVJZICsgJy97aWR9JyArICcve2RhdGFTb3VyY2VNRFNJZD99JyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgaWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICBkYXRhU291cmNlTURTSWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKHsgZGVmYXVsdFZhbHVlOiAnJyB9KSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCByZXRWYWwgPSBhd2FpdCBzZXJ2aWNlLmRlc2NyaWJlU1FMQXN5bmNHZXRRdWVyeShcbiAgICAgICAgY29udGV4dCxcbiAgICAgICAgcmVxdWVzdCxcbiAgICAgICAgcmVxdWVzdC5wYXJhbXMuaWQsXG4gICAgICAgIHJlcXVlc3QucGFyYW1zLmRhdGFTb3VyY2VNRFNJZFxuICAgICAgKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHk6IHJldFZhbCxcbiAgICAgIH0pO1xuICAgIH1cbiAgKTtcblxuICBzZXJ2ZXIuZGVsZXRlKFxuICAgIHtcbiAgICAgIHBhdGg6IFJPVVRFX1BBVEhfU1BBUktfU1FMX0pPQl9RVUVSWSArICcve2lkfScgKyAnL3tkYXRhU291cmNlTURTSWQ/fScsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGlkOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgZGF0YVNvdXJjZU1EU0lkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogJycgfSkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoXG4gICAgICBjb250ZXh0LFxuICAgICAgcmVxdWVzdCxcbiAgICAgIHJlc3BvbnNlXG4gICAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3QgcmV0VmFsID0gYXdhaXQgc2VydmljZS5kZXNjcmliZUFzeW5jRGVsZXRlUXVlcnkoXG4gICAgICAgIGNvbnRleHQsXG4gICAgICAgIHJlcXVlc3QsXG4gICAgICAgIHJlcXVlc3QucGFyYW1zLmlkLFxuICAgICAgICByZXF1ZXN0LnBhcmFtcy5kYXRhU291cmNlTURTSWRcbiAgICAgICk7XG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICBib2R5OiByZXRWYWwsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG5cbiAgc2VydmVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtST1VURV9QQVRIX0dFVF9EQVRBU09VUkNFU30ve2RhdGFTb3VyY2VNRFNJZD99YCxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgZGF0YVNvdXJjZU1EU0lkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogJycgfSkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoXG4gICAgICBjb250ZXh0LFxuICAgICAgcmVxdWVzdCxcbiAgICAgIHJlc3BvbnNlXG4gICAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3QgcmV0VmFsID0gYXdhaXQgc2VydmljZS5kZXNjcmliZVN5bmNRdWVyeURhdGFTb3VyY2VzKGNvbnRleHQsIHJlcXVlc3QpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLm9rKHtcbiAgICAgICAgYm9keTogcmV0VmFsLFxuICAgICAgfSk7XG4gICAgfVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFHQSxJQUFBQyxVQUFBLEdBQUFELE9BQUE7QUFSQTtBQUNBO0FBQ0E7QUFDQTs7QUFtQk8sU0FBU0Usa0JBQWtCQSxDQUFDQyxNQUFlLEVBQUVDLE9BQXFCLEVBQUU7RUFDekVELE1BQU0sQ0FBQ0UsSUFBSSxDQUNUO0lBQ0VDLElBQUksRUFBRUMsK0JBQW9CO0lBQzFCQyxRQUFRLEVBQUU7TUFDUkMsSUFBSSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztNQUNsQkMsS0FBSyxFQUFFRixvQkFBTSxDQUFDRyxNQUFNLENBQUM7UUFDbkJDLGVBQWUsRUFBRUosb0JBQU0sQ0FBQ0ssS0FBSyxDQUFDTCxvQkFBTSxDQUFDTSxNQUFNLENBQUM7VUFBRUMsWUFBWSxFQUFFO1FBQUcsQ0FBQyxDQUFDO01BQ25FLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRCxPQUNFQyxPQUFPLEVBQ1BDLE9BQU8sRUFDUEMsUUFBUSxLQUN3RDtJQUNoRSxNQUFNQyxNQUFNLEdBQUcsTUFBTWpCLE9BQU8sQ0FBQ2tCLGdCQUFnQixDQUFDSixPQUFPLEVBQUVDLE9BQU8sQ0FBQztJQUMvRCxPQUFPQyxRQUFRLENBQUNHLEVBQUUsQ0FBQztNQUNqQmQsSUFBSSxFQUFFWTtJQUNSLENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztFQUVEbEIsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFFa0IsK0JBQW9CO0lBQzFCaEIsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ25CQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUNxQixnQkFBZ0IsQ0FBQ1AsT0FBTyxFQUFFQyxPQUFPLENBQUM7SUFDL0QsT0FBT0MsUUFBUSxDQUFDRyxFQUFFLENBQUM7TUFDakJkLElBQUksRUFBRVk7SUFDUixDQUFDLENBQUM7RUFDSixDQUNGLENBQUM7RUFFRGxCLE1BQU0sQ0FBQ0UsSUFBSSxDQUNUO0lBQ0VDLElBQUksRUFBRW9CLDZCQUFrQjtJQUN4QmxCLFFBQVEsRUFBRTtNQUNSQyxJQUFJLEVBQUVDLG9CQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO01BQ2xCQyxLQUFLLEVBQUVGLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztRQUNuQkMsZUFBZSxFQUFFSixvQkFBTSxDQUFDSyxLQUFLLENBQUNMLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztVQUFFQyxZQUFZLEVBQUU7UUFBRyxDQUFDLENBQUM7TUFDbkUsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNELE9BQ0VDLE9BQU8sRUFDUEMsT0FBTyxFQUNQQyxRQUFRLEtBQ3dEO0lBQ2hFLE1BQU1DLE1BQU0sR0FBRyxNQUFNakIsT0FBTyxDQUFDdUIsY0FBYyxDQUFDVCxPQUFPLEVBQUVDLE9BQU8sQ0FBQztJQUM3RCxPQUFPQyxRQUFRLENBQUNHLEVBQUUsQ0FBQztNQUNqQmQsSUFBSSxFQUFFWTtJQUNSLENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztFQUVEbEIsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFFc0IsNkJBQWtCO0lBQ3hCcEIsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ25CQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUN5QixjQUFjLENBQUNYLE9BQU8sRUFBRUMsT0FBTyxDQUFDO0lBQzdELE9BQU9DLFFBQVEsQ0FBQ0csRUFBRSxDQUFDO01BQ2pCZCxJQUFJLEVBQUVZO0lBQ1IsQ0FBQyxDQUFDO0VBQ0osQ0FDRixDQUFDO0VBRURsQixNQUFNLENBQUNFLElBQUksQ0FDVDtJQUNFQyxJQUFJLEVBQUV3Qiw4QkFBbUI7SUFDekJ0QixRQUFRLEVBQUU7TUFDUkMsSUFBSSxFQUFFQyxvQkFBTSxDQUFDQyxHQUFHLENBQUMsQ0FBQztNQUNsQkMsS0FBSyxFQUFFRixvQkFBTSxDQUFDRyxNQUFNLENBQUM7UUFDbkJDLGVBQWUsRUFBRUosb0JBQU0sQ0FBQ0ssS0FBSyxDQUFDTCxvQkFBTSxDQUFDTSxNQUFNLENBQUM7VUFBRUMsWUFBWSxFQUFFO1FBQUcsQ0FBQyxDQUFDO01BQ25FLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRCxPQUNFQyxPQUFPLEVBQ1BDLE9BQU8sRUFDUEMsUUFBUSxLQUN3RDtJQUNoRSxNQUFNQyxNQUFNLEdBQUcsTUFBTWpCLE9BQU8sQ0FBQzJCLGVBQWUsQ0FBQ2IsT0FBTyxFQUFFQyxPQUFPLENBQUM7SUFDOUQsT0FBT0MsUUFBUSxDQUFDRyxFQUFFLENBQUM7TUFDakJkLElBQUksRUFBRVk7SUFDUixDQUFDLENBQUM7RUFDSixDQUNGLENBQUM7RUFFRGxCLE1BQU0sQ0FBQ0UsSUFBSSxDQUNUO0lBQ0VDLElBQUksRUFBRTBCLDhCQUFtQjtJQUN6QnhCLFFBQVEsRUFBRTtNQUNSQyxJQUFJLEVBQUVDLG9CQUFNLENBQUNDLEdBQUcsQ0FBQyxDQUFDO01BQ2xCQyxLQUFLLEVBQUVGLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztRQUNuQkMsZUFBZSxFQUFFSixvQkFBTSxDQUFDSyxLQUFLLENBQUNMLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztVQUFFQyxZQUFZLEVBQUU7UUFBRyxDQUFDLENBQUM7TUFDbkUsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNELE9BQ0VDLE9BQU8sRUFDUEMsT0FBTyxFQUNQQyxRQUFRLEtBQ3dEO0lBQ2hFLE1BQU1DLE1BQU0sR0FBRyxNQUFNakIsT0FBTyxDQUFDNkIsZUFBZSxDQUFDZixPQUFPLEVBQUVDLE9BQU8sQ0FBQztJQUM5RCxPQUFPQyxRQUFRLENBQUNHLEVBQUUsQ0FBQztNQUNqQmQsSUFBSSxFQUFFWTtJQUNSLENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztFQUVEbEIsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFFNEIsOEJBQW1CO0lBQ3pCMUIsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ25CQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUMrQixlQUFlLENBQUNqQixPQUFPLEVBQUVDLE9BQU8sQ0FBQztJQUM5RCxPQUFPQyxRQUFRLENBQUNHLEVBQUUsQ0FBQztNQUNqQmQsSUFBSSxFQUFFWTtJQUNSLENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztFQUVEbEIsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFFOEIsOEJBQW1CO0lBQ3pCNUIsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ25CQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUNpQyxlQUFlLENBQUNuQixPQUFPLEVBQUVDLE9BQU8sQ0FBQztJQUM5RCxPQUFPQyxRQUFRLENBQUNHLEVBQUUsQ0FBQztNQUNqQmQsSUFBSSxFQUFFWTtJQUNSLENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztFQUVEbEIsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFFZ0MscUNBQTBCO0lBQ2hDOUIsUUFBUSxFQUFFO01BQ1JDLElBQUksRUFBRUMsb0JBQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUM7TUFDbEJDLEtBQUssRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ25CQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUNtQyxxQkFBcUIsQ0FBQ3JCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO0lBQ3BFLE9BQU9DLFFBQVEsQ0FBQ0csRUFBRSxDQUFDO01BQ2pCZCxJQUFJLEVBQUVZO0lBQ1IsQ0FBQyxDQUFDO0VBQ0osQ0FDRixDQUFDO0VBRURsQixNQUFNLENBQUNxQyxHQUFHLENBQ1I7SUFDRWxDLElBQUksRUFBRW1DLHlDQUE4QixHQUFHLE9BQU8sR0FBRyxxQkFBcUI7SUFDdEVqQyxRQUFRLEVBQUU7TUFDUmtDLE1BQU0sRUFBRWhDLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztRQUNwQjhCLEVBQUUsRUFBRWpDLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDO1FBQ25CRixlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUN3Qyx3QkFBd0IsQ0FDbkQxQixPQUFPLEVBQ1BDLE9BQU8sRUFDUEEsT0FBTyxDQUFDdUIsTUFBTSxDQUFDQyxFQUFFLEVBQ2pCeEIsT0FBTyxDQUFDdUIsTUFBTSxDQUFDNUIsZUFDakIsQ0FBQztJQUNELE9BQU9NLFFBQVEsQ0FBQ0csRUFBRSxDQUFDO01BQ2pCZCxJQUFJLEVBQUVZO0lBQ1IsQ0FBQyxDQUFDO0VBQ0osQ0FDRixDQUFDO0VBRURsQixNQUFNLENBQUMwQyxNQUFNLENBQ1g7SUFDRXZDLElBQUksRUFBRW1DLHlDQUE4QixHQUFHLE9BQU8sR0FBRyxxQkFBcUI7SUFDdEVqQyxRQUFRLEVBQUU7TUFDUmtDLE1BQU0sRUFBRWhDLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztRQUNwQjhCLEVBQUUsRUFBRWpDLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDO1FBQ25CRixlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUMwQyx3QkFBd0IsQ0FDbkQ1QixPQUFPLEVBQ1BDLE9BQU8sRUFDUEEsT0FBTyxDQUFDdUIsTUFBTSxDQUFDQyxFQUFFLEVBQ2pCeEIsT0FBTyxDQUFDdUIsTUFBTSxDQUFDNUIsZUFDakIsQ0FBQztJQUNELE9BQU9NLFFBQVEsQ0FBQ0csRUFBRSxDQUFDO01BQ2pCZCxJQUFJLEVBQUVZO0lBQ1IsQ0FBQyxDQUFDO0VBQ0osQ0FDRixDQUFDO0VBRURsQixNQUFNLENBQUNxQyxHQUFHLENBQ1I7SUFDRWxDLElBQUksRUFBRyxHQUFFeUMscUNBQTJCLHFCQUFvQjtJQUN4RHZDLFFBQVEsRUFBRTtNQUNSa0MsTUFBTSxFQUFFaEMsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1FBQ3BCQyxlQUFlLEVBQUVKLG9CQUFNLENBQUNLLEtBQUssQ0FBQ0wsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO1VBQUVDLFlBQVksRUFBRTtRQUFHLENBQUMsQ0FBQztNQUNuRSxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsTUFBTUMsTUFBTSxHQUFHLE1BQU1qQixPQUFPLENBQUM0Qyw0QkFBNEIsQ0FBQzlCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO0lBQzNFLE9BQU9DLFFBQVEsQ0FBQ0csRUFBRSxDQUFDO01BQ2pCZCxJQUFJLEVBQUVZO0lBQ1IsQ0FBQyxDQUFDO0VBQ0osQ0FDRixDQUFDO0FBQ0gifQ==