"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsonFromString = void 0;
var _stream = require("stream");
var _csvParser = _interopRequireDefault(require("csv-parser"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getJsonFromString = (csvString, options) => {
  const results = [];
  return new Promise((resolve, reject) => {
    _stream.Readable.from(csvString).pipe((0, _csvParser.default)(options)).on('data', data => results.push(data)).on('end', () => {
      resolve(results);
    }).on('error', err => {
      reject(err);
    });
  });
};
exports.getJsonFromString = getJsonFromString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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