"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INVALID_NEXT_URL_PARAMETER_MESSAGE = void 0;
exports.composeNextUrlQueryParam = composeNextUrlQueryParam;
exports.validateNextUrl = validateNextUrl;
var _url = require("url");
var _encode_uri_query = require("../../../../src/plugins/opensearch_dashboards_utils/common/url/encode_uri_query");
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

function composeNextUrlQueryParam(request, basePath) {
  try {
    const currentUrl = request.url.toString();
    const parsedUrl = (0, _url.parse)(currentUrl, true);
    const nextUrl = parsedUrl === null || parsedUrl === void 0 ? void 0 : parsedUrl.path;
    if (!!nextUrl && nextUrl !== '/') {
      return `nextUrl=${(0, _encode_uri_query.encodeUriQuery)(basePath + nextUrl)}`;
    }
  } catch (error) {
    /* Ignore errors from parsing */
  }
  return '';
}
const INVALID_NEXT_URL_PARAMETER_MESSAGE = exports.INVALID_NEXT_URL_PARAMETER_MESSAGE = 'Invalid nextUrl parameter.';

/**
 * We require the nextUrl parameter to be an relative url.
 *
 * Here we validate the nextUrl parameter by checking if it meets the following criteria:
 *   - nextUrl starts with the basePath (/ if no serverBasePath is set)
 *   - If nextUrl is longer than 2 chars then the second character must be alphabetical or underscore
 *   - The following characters must be alphanumeric, dash or underscore
 * Note: url has been decoded by OpenSearchDashboards.
 *
 * @param url url string.
 * @returns error message if nextUrl is invalid, otherwise void.
 */
function validateNextUrl(url, basePath) {
  if (url) {
    const path = url.split(/\?|#/)[0];
    const bp = basePath || '';
    if (!path.startsWith(bp)) {
      return INVALID_NEXT_URL_PARAMETER_MESSAGE;
    }
    const pathMinusBase = path.replace(bp, '');
    if (!pathMinusBase.startsWith('/') || pathMinusBase.length >= 2 && !/^\/[a-zA-Z_][\/a-zA-Z0-9-_]+$/.test(pathMinusBase)) {
      return INVALID_NEXT_URL_PARAMETER_MESSAGE;
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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