/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public class DefaultJvmVendorSpec
extends JvmVendorSpec
implements Predicate<JvmInstallationMetadata> {
    private static final JvmVendorSpec ANY = new DefaultJvmVendorSpec(v -> true, "any");
    private final Predicate<JvmVendor> matcher;
    private final String description;

    public static JvmVendorSpec matching(String match) {
        return new DefaultJvmVendorSpec(vendor -> StringUtils.containsIgnoreCase((String)vendor.getRawVendor(), (String)match), "matching('" + match + "')");
    }

    public static JvmVendorSpec of(JvmVendor.KnownJvmVendor knownVendor) {
        return new DefaultJvmVendorSpec(vendor -> vendor.getKnownVendor() == knownVendor, knownVendor.toString());
    }

    public static JvmVendorSpec any() {
        return ANY;
    }

    private DefaultJvmVendorSpec(Predicate<JvmVendor> predicate, String description) {
        this.matcher = predicate;
        this.description = description;
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        JvmVendor vendor = metadata.getVendor();
        return this.test(vendor);
    }

    @Override
    public boolean test(JvmVendor vendor) {
        return this.matcher.test(vendor);
    }

    @Override
    public boolean matches(String vendor) {
        return this.test(JvmVendor.fromString((String)vendor));
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJvmVendorSpec that = (DefaultJvmVendorSpec)o;
        return Objects.equal((Object)this.description, (Object)that.description);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description});
    }
}

