/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.util.Formatter;
import java.util.List;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.NextGenBuildCacheController;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.caching.impl.DefaultCachingStateFactory;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class ResolveCachingStateStep<C extends ValidationFinishedContext>
implements Step<C, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveCachingStateStep.class);
    private static final CachingDisabledReason BUILD_CACHE_DISABLED_REASON = new CachingDisabledReason(CachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Build cache is disabled");
    private static final CachingState BUILD_CACHE_DISABLED_STATE = CachingState.disabledWithoutInputs(BUILD_CACHE_DISABLED_REASON);
    private static final CachingDisabledReason VALIDATION_FAILED_REASON = new CachingDisabledReason(CachingDisabledReasonCategory.VALIDATION_FAILURE, "Caching has been disabled to ensure correctness. Please consult deprecation warnings for more details.");
    private static final CachingState VALIDATION_FAILED_STATE = CachingState.disabledWithoutInputs(VALIDATION_FAILED_REASON);
    private final BuildCacheController buildCache;
    private final boolean buildScansEnabled;
    private final Step<? super CachingContext, ? extends UpToDateResult> delegate;

    public ResolveCachingStateStep(BuildCacheController buildCache, boolean buildScansEnabled, Step<? super CachingContext, ? extends UpToDateResult> delegate) {
        this.buildCache = buildCache;
        this.buildScansEnabled = buildScansEnabled;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, C context) {
        CachingState cachingState = !this.buildCache.isEnabled() && !this.buildScansEnabled ? BUILD_CACHE_DISABLED_STATE : (!((ValidationFinishedContext)context).getValidationProblems().isEmpty() ? VALIDATION_FAILED_STATE : ((BeforeExecutionContext)context).getBeforeExecutionState().map(beforeExecutionState -> this.calculateCachingState(work, (BeforeExecutionState)beforeExecutionState)).orElseGet(() -> this.calculateCachingStateWithNoCapturedInputs(work)));
        cachingState.apply(enabled -> this.logCacheKey(enabled.getKey(), work), disabled -> this.logDisabledReasons((List<CachingDisabledReason>)disabled.getDisabledReasons(), work));
        UpToDateResult result = this.delegate.execute(work, new CachingContext((ValidationFinishedContext)context, cachingState));
        return new CachingResult(result, cachingState);
    }

    private CachingState calculateCachingState(UnitOfWork work, BeforeExecutionState beforeExecutionState) {
        Logger logger = this.buildCache.isEmitDebugLogging() ? LOGGER : NOPLogger.NOP_LOGGER;
        DefaultCachingStateFactory cachingStateFactory = new DefaultCachingStateFactory(logger);
        ImmutableList.Builder cachingDisabledReasonsBuilder = ImmutableList.builder();
        if (!this.buildCache.isEnabled()) {
            cachingDisabledReasonsBuilder.add((Object)BUILD_CACHE_DISABLED_REASON);
        }
        OverlappingOutputs detectedOverlappingOutputs = beforeExecutionState.getDetectedOverlappingOutputs().orElse(null);
        work.shouldDisableCaching(detectedOverlappingOutputs).ifPresent(arg_0 -> ((ImmutableList.Builder)cachingDisabledReasonsBuilder).add(arg_0));
        String cacheSalt = NextGenBuildCacheController.isNextGenCachingEnabled() ? "next-gen" : null;
        return cachingStateFactory.createCachingState(beforeExecutionState, cacheSalt, (ImmutableList<CachingDisabledReason>)cachingDisabledReasonsBuilder.build());
    }

    private CachingState calculateCachingStateWithNoCapturedInputs(UnitOfWork work) {
        if (!this.buildCache.isEnabled()) {
            return BUILD_CACHE_DISABLED_STATE;
        }
        return work.shouldDisableCaching(null).map(CachingState::disabledWithoutInputs).orElse(CachingState.NOT_DETERMINED);
    }

    private void logCacheKey(BuildCacheKey cacheKey, UnitOfWork work) {
        if (this.buildCache.isEmitDebugLogging()) {
            LOGGER.warn("Build cache key for {} is {}", (Object)work.getDisplayName(), (Object)cacheKey.getDisplayName());
        } else {
            LOGGER.info("Build cache key for {} is {}", (Object)work.getDisplayName(), (Object)cacheKey.getDisplayName());
        }
    }

    private void logDisabledReasons(List<CachingDisabledReason> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("Caching disabled for %s because:", work.getDisplayName());
            for (CachingDisabledReason reason : reasons) {
                formatter.format("%n  %s", reason.getMessage());
            }
            LOGGER.info(formatter.toString());
        }
    }
}

