/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.SelectedVariantSerializer;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

@ThreadSafe
public class ThisBuildOnlySelectedVariantSerializer
implements SelectedVariantSerializer {
    private final Long2ObjectMap<VariantGraphResolveState> variants = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());

    @Override
    public void writeVariantResult(ResolvedGraphVariant variant, Encoder encoder) throws IOException {
        encoder.writeSmallLong(variant.getNodeId().longValue());
        VariantGraphResolveState state = variant.getResolveState();
        this.writeVariantReference(encoder, state);
        ResolvedGraphVariant externalVariant = variant.getExternalVariant();
        if (externalVariant == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            this.writeVariantReference(encoder, externalVariant.getResolveState());
        }
    }

    private void writeVariantReference(Encoder encoder, VariantGraphResolveState state) throws IOException {
        long instanceId = state.getInstanceId();
        this.variants.putIfAbsent(instanceId, (Object)state);
        encoder.writeSmallLong(instanceId);
    }

    @Override
    public void readSelectedVariant(Decoder decoder, ResolvedComponentVisitor visitor) throws IOException {
        long nodeId = decoder.readSmallLong();
        VariantGraphResolveState variant = this.readVariantReference(decoder);
        ResolvedVariantResult externalVariant = decoder.readBoolean() ? this.readVariantReference(decoder).getVariantResult(null) : null;
        visitor.visitSelectedVariant(nodeId, variant.getVariantResult(externalVariant));
    }

    private VariantGraphResolveState readVariantReference(Decoder decoder) throws IOException {
        long instanceId = decoder.readSmallLong();
        VariantGraphResolveState variant = (VariantGraphResolveState)this.variants.get(instanceId);
        if (variant == null) {
            throw new IllegalStateException("No variant with id " + instanceId + " found.");
        }
        return variant;
    }
}

