/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectWriter;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeItemHeader
implements JsonSerializable,
JsonUnknown {
    @Nullable
    private final String contentType;
    @Nullable
    private final String fileName;
    @NotNull
    private final SentryItemType type;
    private final int length;
    @Nullable
    private final Callable<Integer> getLength;
    @Nullable
    private final String attachmentType;
    @Nullable
    private Map<String, Object> unknown;

    @NotNull
    public SentryItemType getType() {
        return this.type;
    }

    public int getLength() {
        if (this.getLength != null) {
            try {
                return this.getLength.call();
            }
            catch (Throwable ignored) {
                return -1;
            }
        }
        return this.length;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @ApiStatus.Internal
    public SentryEnvelopeItemHeader(@NotNull SentryItemType type, int length, @Nullable String contentType, @Nullable String fileName, @Nullable String attachmentType) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.contentType = contentType;
        this.length = length;
        this.fileName = fileName;
        this.getLength = null;
        this.attachmentType = attachmentType;
    }

    SentryEnvelopeItemHeader(@NotNull SentryItemType type, @Nullable Callable<Integer> getLength, @Nullable String contentType, @Nullable String fileName, @Nullable String attachmentType) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.contentType = contentType;
        this.length = -1;
        this.fileName = fileName;
        this.getLength = getLength;
        this.attachmentType = attachmentType;
    }

    SentryEnvelopeItemHeader(@NotNull SentryItemType type, @Nullable Callable<Integer> getLength, @Nullable String contentType, @Nullable String fileName) {
        this(type, getLength, contentType, fileName, null);
    }

    @Nullable
    public String getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.contentType != null) {
            writer.name("content_type").value(this.contentType);
        }
        if (this.fileName != null) {
            writer.name("filename").value(this.fileName);
        }
        writer.name("type").value(logger, this.type);
        if (this.attachmentType != null) {
            writer.name("attachment_type").value(this.attachmentType);
        }
        writer.name("length").value(this.getLength());
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value2 = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value2);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String CONTENT_TYPE = "content_type";
        public static final String FILENAME = "filename";
        public static final String TYPE = "type";
        public static final String ATTACHMENT_TYPE = "attachment_type";
        public static final String LENGTH = "length";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryEnvelopeItemHeader> {
        @Override
        @NotNull
        public SentryEnvelopeItemHeader deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            String contentType = null;
            String fileName = null;
            SentryItemType type = null;
            int length = 0;
            String attachmentType = null;
            HashMap<String, Object> unknown = null;
            block14: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "content_type": {
                        contentType = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "filename": {
                        fileName = reader.nextStringOrNull();
                        continue block14;
                    }
                    case "type": {
                        type = reader.nextOrNull(logger, new SentryItemType.Deserializer());
                        continue block14;
                    }
                    case "length": {
                        length = reader.nextInt();
                        continue block14;
                    }
                    case "attachment_type": {
                        attachmentType = reader.nextStringOrNull();
                        continue block14;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (type == null) {
                throw this.missingRequiredFieldException("type", logger);
            }
            SentryEnvelopeItemHeader sentryEnvelopeItemHeader = new SentryEnvelopeItemHeader(type, length, contentType, fileName, attachmentType);
            sentryEnvelopeItemHeader.setUnknown(unknown);
            reader.endObject();
            return sentryEnvelopeItemHeader;
        }

        private Exception missingRequiredFieldException(String field, ILogger logger) {
            String message = "Missing required field \"" + field + "\"";
            IllegalStateException exception = new IllegalStateException(message);
            logger.log(SentryLevel.ERROR, message, exception);
            return exception;
        }
    }
}

