/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0016J\u001a\u0010\"\u001a\u00020\u00072\u0010\u0010#\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010!H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0014\u00a2\u0006\u0002\u0010+J,\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0018\u00104\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lorg/jitsi/nlj/dtls/TlsClientImpl;", "Lorg/bouncycastle/tls/DefaultTlsClient;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyServerCertificate", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "clientCredentials", "Lorg/bouncycastle/tls/TlsCredentials;", "srtpKeyingMaterial", "", "getSrtpKeyingMaterial", "()[B", "setSrtpKeyingMaterial", "([B)V", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "getSessionToResume", "getAuthentication", "Lorg/bouncycastle/tls/TlsAuthentication;", "getClientExtensions", "Ljava/util/Hashtable;", "processServerExtensions", "serverExtensions", "getCipherSuites", "", "getHandshakeTimeoutMillis", "notifyHandshakeComplete", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
@SourceDebugExtension(value={"SMAP\nTlsClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsClientImpl.kt\norg/jitsi/nlj/dtls/TlsClientImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtilsKt\n*L\n1#1,175:1\n57#2,4:176\n63#2,4:180\n63#2,4:184\n63#2,4:190\n57#2,2:202\n60#2:206\n57#2,4:210\n75#2:215\n76#2:218\n331#3,2:188\n334#3,8:194\n342#3,2:204\n347#3:207\n351#3,2:208\n353#3:214\n354#3,2:216\n358#3:219\n*S KotlinDebug\n*F\n+ 1 TlsClientImpl.kt\norg/jitsi/nlj/dtls/TlsClientImpl\n*L\n140#1:176,4\n145#1:180,4\n151#1:184,4\n170#1:190,4\n170#1:202,2\n170#1:206\n173#1:210,4\n173#1:215\n173#1:218\n170#1:188,2\n170#1:194,8\n170#1:204,2\n170#1:207\n173#1:208,2\n173#1:214\n173#1:216,2\n173#1:219\n*E\n"})
public final class TlsClientImpl
extends DefaultTlsClient {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyServerCertificate;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    @Nullable
    private TlsCredentials clientCredentials;
    public byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsClientImpl(@NotNull CertificateInfo certificateInfo, @NotNull Function1<? super Certificate, Unit> notifyServerCertificate, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(certificateInfo, "certificateInfo");
        Intrinsics.checkNotNullParameter(notifyServerCertificate, "notifyServerCertificate");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo;
        this.notifyServerCertificate = notifyServerCertificate;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srtpKeyingMaterial");
        return null;
    }

    public final void setSrtpKeyingMaterial(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.srtpKeyingMaterial = byArray;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Override
    @Nullable
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @Override
    @NotNull
    public TlsAuthentication getAuthentication() {
        return new TlsAuthentication(this){
            final /* synthetic */ TlsClientImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) {
                Intrinsics.checkNotNullParameter(certificateRequest, "certificateRequest");
                if (TlsClientImpl.access$getClientCredentials$p(this.this$0) == null) {
                    TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters(TlsClientImpl.access$getContext$p(this.this$0));
                    TlsCrypto tlsCrypto = TlsClientImpl.access$getContext$p(this.this$0).getCrypto();
                    Intrinsics.checkNotNull(tlsCrypto, "null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
                    TlsClientImpl.access$setClientCredentials$p(this.this$0, new BcDefaultTlsCredentialedSigner(tlsCryptoParameters, (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey(TlsClientImpl.access$getCertificateInfo$p(this.this$0).getKeyPair().getPrivate().getEncoded()), TlsClientImpl.access$getCertificateInfo$p(this.this$0).getCertificate(), TlsUtils.isSignatureAlgorithmsExtensionAllowed(TlsClientImpl.access$getContext$p(this.this$0).getServerVersion()) ? new SignatureAndHashAlgorithm(4, 3) : null));
                }
                TlsCredentials tlsCredentials = TlsClientImpl.access$getClientCredentials$p(this.this$0);
                Intrinsics.checkNotNull(tlsCredentials);
                return tlsCredentials;
            }

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) {
                Intrinsics.checkNotNullParameter(serverCertificate, "serverCertificate");
                TlsClientImpl.access$getNotifyServerCertificate$p(this.this$0).invoke(serverCertificate.getCertificate());
            }
        };
    }

    @Override
    @NotNull
    public Hashtable<?, ?> getClientExtensions() {
        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
        if (TlsSRTPUtils.getUseSRTPExtension(clientExtensions) == null) {
            if (clientExtensions == null) {
                clientExtensions = new Hashtable<Integer, byte[]>();
            }
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, new UseSRTPData(CollectionsKt.toIntArray((Collection<Integer>)SrtpConfig.Companion.getProtectionProfiles()), TlsUtils.EMPTY_BYTES));
        }
        Object object = new byte[]{0};
        clientExtensions.put(65281, (byte[])object);
        object = clientExtensions;
        Intrinsics.checkNotNull(object);
        return object;
    }

    public void processServerExtensions(@Nullable Hashtable<?, ?> serverExtensions) {
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(serverExtensions);
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNull(protectionProfiles);
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable(protectionProfiles));
    }

    @Override
    @NotNull
    public int[] getCipherSuites() {
        return CollectionsKt.toIntArray((Collection<Integer>)DtlsConfig.Companion.getConfig().getCipherSuites());
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return (int)DtlsUtils.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    @Override
    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Negotiated DTLS version " + this.context.getSecurityParameters().getNegotiatedVersion());
        }
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            TlsSession newSession = tlsSession;
            boolean bl = false;
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl4 = false;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                        Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(...)");
                        String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
                        logger.debug("Resumed DTLS session " + newSessionIdHex);
                    }
                }
            } else {
                TlsClientImpl $this$notifyHandshakeComplete_u24lambda_u245_u24lambda_u244 = this;
                boolean bl5 = false;
                Logger $this$cdebug$iv = $this$notifyHandshakeComplete_u24lambda_u245_u24lambda_u244.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl6 = false;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(...)");
                    String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
                    logger.debug("Established DTLS session " + newSessionIdHex);
                }
                $this$notifyHandshakeComplete_u24lambda_u245_u24lambda_u244.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        this.setSrtpKeyingMaterial(this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength())));
    }

    @Override
    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[]{ProtocolVersion.DTLSv12};
        return protocolVersionArray;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        Logger $this$notifyAlertRaised$iv = this.logger;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription == 0) {
            Logger $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv$iv;
                boolean bl = false;
                logger.debug("close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u241$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            Iterator<StackTraceElement> iterator2 = ArrayIteratorKt.iterator(e$iv.getStackTrace());
            while (iterator2.hasNext()) {
                StackTraceElement el$iv = iterator2.next();
                Appendable appendable = ((Appendable)$this$notifyAlertRaised_u24lambda_u241$iv).append(el$iv.toString());
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
            }
            String string = $this$notifyAlertRaised_u24lambda_u241$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string, "with(...)");
            String stack$iv = string;
            Logger $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl2 = false;
                logger.info("Alert raised: level=" + alertLevel + ", description=" + alertDescription + ", message=" + message + " cause=" + cause + " " + stack$iv);
            }
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Logger $this$notifyAlertReceived$iv = this.logger;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription == 0) {
            Logger $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl = false;
                logger.info("close_notify received, connection closing");
            }
        } else {
            Logger $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            Logger logger = $this$cerror$iv$iv;
            boolean bl = false;
            logger.error("Alert received: level=" + alertLevel + ", description=" + alertDescription + " (" + AlertDescription.getName(alertDescription) + ")");
        }
    }

    public static final /* synthetic */ TlsCredentials access$getClientCredentials$p(TlsClientImpl $this) {
        return $this.clientCredentials;
    }

    public static final /* synthetic */ void access$setClientCredentials$p(TlsClientImpl $this, TlsCredentials tlsCredentials) {
        $this.clientCredentials = tlsCredentials;
    }

    public static final /* synthetic */ TlsClientContext access$getContext$p(TlsClientImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ CertificateInfo access$getCertificateInfo$p(TlsClientImpl $this) {
        return $this.certificateInfo;
    }

    public static final /* synthetic */ Function1 access$getNotifyServerCertificate$p(TlsClientImpl $this) {
        return $this.notifyServerCertificate;
    }
}

