/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class AddWayHandler
extends RequestHandler {
    public static final String command = "add_way";
    private final List<LatLon> allCoordinates = new ArrayList<LatLon>();
    private Way way;
    private Map<LatLon, Node> addedNodes;

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"way"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"addtags"};
    }

    @Override
    public String getUsage() {
        return "adds a way (given by a semicolon separated sequence of lat,lon pairs) to the current dataset";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/add_way?way=53.2,13.3;53.3,13.3;53.3,13.2", "/add_way?&addtags=building=yes&way=45.437213,-2.810792;45.437988,-2.455983;45.224080,-2.455036;45.223302,-2.809845;45.437213,-2.810792"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        GuiHelper.runInEDTAndWait(() -> {
            this.way = this.addWay();
        });
        AddTagsDialog.addTags(this.args, this.sender, Collections.singleton(this.way));
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new way.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.CREATE_OBJECTS;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.allCoordinates.clear();
        for (String coordinatesString : this.splitArg("way", SPLITTER_SEMIC)) {
            Object[] coordinates = coordinatesString.split(",\\s*", 2);
            if (coordinates.length < 2) {
                throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("Invalid coordinates: {0}", Arrays.toString(coordinates)));
            }
            try {
                double lat = Double.parseDouble(coordinates[0]);
                double lon = Double.parseDouble((String)coordinates[1]);
                this.allCoordinates.add(new LatLon(lat, lon));
            }
            catch (NumberFormatException e) {
                throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + e.getMessage() + ')', e);
            }
        }
        if (this.allCoordinates.isEmpty()) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("Empty ways", new Object[0]));
        }
        if (this.allCoordinates.size() == 1) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("One node ways", new Object[0]));
        }
        if (MainApplication.getLayerManager().getEditLayer() == null) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("There is no layer opened to add way", new Object[0]));
        }
    }

    Node findOrCreateNode(LatLon ll, List<Command> commands) {
        MapView mapView;
        Node nd = null;
        if (MainApplication.isDisplayingMapView() && (nd = (mapView = MainApplication.getMap().mapView).getNearestNode(mapView.getPoint(ll), AbstractPrimitive::isUsable)) != null && nd.getCoor().greatCircleDistance(ll) > Config.getPref().getDouble("remote.tolerance", 0.1)) {
            nd = null;
        }
        Node prev = null;
        for (Map.Entry<LatLon, Node> entry : this.addedNodes.entrySet()) {
            LatLon lOld = entry.getKey();
            if (!(lOld.greatCircleDistance(ll) < Config.getPref().getDouble("remotecontrol.tolerance", 0.1))) continue;
            prev = entry.getValue();
            break;
        }
        if (prev != null) {
            nd = prev;
        } else if (nd == null) {
            nd = new Node(ll);
            commands.add(new AddCommand(OsmDataManager.getInstance().getEditDataSet(), nd));
            this.addedNodes.put(ll, nd);
        }
        return nd;
    }

    private Way addWay() {
        this.addedNodes = new HashMap<LatLon, Node>();
        Way way = new Way();
        LinkedList<Command> commands = new LinkedList<Command>();
        for (LatLon ll : this.allCoordinates) {
            Node node = this.findOrCreateNode(ll, commands);
            way.addNode(node);
        }
        this.allCoordinates.clear();
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        commands.add(new AddCommand(ds, way));
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Add way", new Object[0]), commands));
        ds.setSelected(way);
        if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            AutoScaleAction.autoScale(AutoScaleAction.AutoScaleMode.SELECTION);
        } else {
            MainApplication.getMap().mapView.repaint();
        }
        return way;
    }
}

