/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.SignatureCalculator;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangePreparator<T extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected BigInteger publicKey;
    protected SignatureAndHashAlgorithm selectedSignatureHashAlgo;
    protected byte[] signature;
    protected final T msg;

    public DHEServerKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, (ServerKeyExchangeMessage)message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.setDheParams();
        this.preparePublicKey(this.msg);
        this.prepareDheParams();
        this.selectedSignatureHashAlgo = this.chooser.getSelectedSigHashAlgorithm();
        this.prepareSignatureAndHashAlgorithm(this.msg);
        this.signature = new byte[0];
        try {
            this.signature = this.generateSignature(this.selectedSignatureHashAlgo);
        }
        catch (CryptoException E) {
            LOGGER.warn("Could not generate Signature! Using empty one instead!", (Throwable)E);
        }
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
    }

    protected void setDheParams() {
        ((DHEServerKeyExchangeMessage)this.msg).prepareComputations();
        this.setComputedGenerator(this.msg);
        this.setComputedModulus(this.msg);
        this.setComputedPrivateKey(this.msg);
    }

    protected void prepareDheParams() {
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareClientServerRandom(this.msg);
        this.preparePublicKeyLength(this.msg);
    }

    protected byte[] generateToBeSigned() {
        byte[] dhParams = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)((Integer)((DHEServerKeyExchangeMessage)this.msg).getModulusLength().getValue()), (int)2), (byte[])((DHEServerKeyExchangeMessage)this.msg).getModulus().getValue(), ArrayConverter.intToBytes((int)((Integer)((DHEServerKeyExchangeMessage)this.msg).getGeneratorLength().getValue()), (int)2), (byte[])((DHEServerKeyExchangeMessage)this.msg).getGenerator().getValue(), ArrayConverter.intToBytes((int)((Integer)((ServerKeyExchangeMessage)this.msg).getPublicKeyLength().getValue()), (int)2), (byte[])((ServerKeyExchangeMessage)this.msg).getPublicKey().getValue()});
        return ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])((DHEServerKeyExchangeMessage)this.msg).getComputations().getClientServerRandom().getValue(), dhParams});
    }

    protected byte[] generateSignature(SignatureAndHashAlgorithm algorithm) throws CryptoException {
        return SignatureCalculator.generateSignature(algorithm, this.chooser, this.generateToBeSigned());
    }

    protected void prepareGenerator(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setGenerator(((DHEServerKeyExchangeMessage)msg).getComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: " + ArrayConverter.bytesToHexString((byte[])((byte[])((DHEServerKeyExchangeMessage)msg).getGenerator().getValue())));
    }

    protected void prepareModulus(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setModulus(((DHEServerKeyExchangeMessage)msg).getComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: " + ArrayConverter.bytesToHexString((byte[])((byte[])((DHEServerKeyExchangeMessage)msg).getModulus().getValue())));
    }

    protected void prepareGeneratorLength(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setGeneratorLength(((byte[])((DHEServerKeyExchangeMessage)msg).getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: " + ((DHEServerKeyExchangeMessage)msg).getGeneratorLength().getValue());
    }

    protected void prepareModulusLength(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setModulusLength(((byte[])((DHEServerKeyExchangeMessage)msg).getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: " + ((DHEServerKeyExchangeMessage)msg).getModulusLength().getValue());
    }

    protected void preparePublicKey(T msg) {
        BigInteger publicKey = this.chooser.getDhServerPublicKey();
        try {
            BigInteger generator = (BigInteger)((DHEServerKeyExchangeMessage)msg).getComputations().getGenerator().getValue();
            publicKey = generator.modPow((BigInteger)((DHEServerKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue(), (BigInteger)((DHEServerKeyExchangeMessage)msg).getComputations().getModulus().getValue());
        }
        catch (Exception E) {
            LOGGER.warn("Could not compute public key", (Throwable)E);
        }
        ((ServerKeyExchangeMessage)msg).setPublicKey(ArrayConverter.bigIntegerToByteArray((BigInteger)publicKey));
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue())));
    }

    protected void preparePublicKeyLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: " + ((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void setComputedPrivateKey(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getDhServerPrivateKey());
        LOGGER.debug("PrivateKey: " + ((DHEServerKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue());
    }

    protected void setComputedModulus(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getComputations().setModulus(this.chooser.getServerDhModulus());
        LOGGER.debug("Modulus used for Computations: " + ((BigInteger)((DHEServerKeyExchangeMessage)msg).getComputations().getModulus().getValue()).toString(16));
    }

    protected void setComputedGenerator(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getComputations().setGenerator(this.chooser.getServerDhGenerator());
        LOGGER.debug("Generator used for Computations: " + ((BigInteger)((DHEServerKeyExchangeMessage)msg).getComputations().getGenerator().getValue()).toString(16));
    }

    protected void prepareSignatureAndHashAlgorithm(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureAndHashAlgorithm(this.selectedSignatureHashAlgo.getByteValue());
        LOGGER.debug("SignatureAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue())));
    }

    protected void prepareClientServerRandom(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getComputations().setClientServerRandom(ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((DHEServerKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    protected void prepareSignature(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignature(this.signature);
        LOGGER.debug("Signatur: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue())));
    }

    protected void prepareSignatureLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureLength(((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: " + ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }
}

