/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloRetryRequestSerializer
extends HandshakeMessageSerializer<HelloRetryRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HelloRetryRequestMessage msg;

    public HelloRetryRequestSerializer(HelloRetryRequestMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        this.writeProtocolVersion();
        this.writeSelectedCiphersuite();
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength();
            if (this.hasExtensions()) {
                this.writeExtensionBytes();
            }
        }
        return this.getAlreadySerialized();
    }

    protected void writeProtocolVersion() {
        this.appendBytes((byte[])this.msg.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getProtocolVersion().getValue())));
    }

    protected void writeSelectedCiphersuite() {
        this.appendBytes((byte[])this.msg.getSelectedCipherSuite().getValue());
        LOGGER.debug("SelectedCipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getSelectedCipherSuite().getValue())));
    }
}

