/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import javax.swing.ImageIcon;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.util.Utils;

public class GoodsTypeLabel
extends FreeColLabel {
    private final ImageLibrary imageLibrary;
    private final GoodsType goodsType;

    public GoodsTypeLabel(FreeColClient freeColClient, GoodsType goodsType) {
        this(freeColClient.getGUI().getFixedImageLibrary(), goodsType);
    }

    public GoodsTypeLabel(GoodsTypeLabel goodsTypeLabel) {
        this(goodsTypeLabel.getImageLibrary(), goodsTypeLabel.getType());
    }

    private GoodsTypeLabel(ImageLibrary imageLibrary, GoodsType goodsType) {
        super(new ImageIcon(imageLibrary.getScaledGoodsTypeImage(goodsType)));
        this.imageLibrary = imageLibrary;
        this.goodsType = goodsType;
        this.setToolTipText(Messages.getName(goodsType));
    }

    protected ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public GoodsType getType() {
        return this.goodsType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GoodsTypeLabel) {
            GoodsTypeLabel other = (GoodsTypeLabel)o;
            return Utils.equals(this.goodsType, other.goodsType);
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.goodsType);
        return hash;
    }
}

