/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;
import org.keycloak.representations.idm.MembershipType;

public interface OrganizationProvider
extends Provider {
    default public OrganizationModel create(String name, String alias) {
        return this.create(null, name, alias);
    }

    public OrganizationModel create(String var1, String var2, String var3);

    public OrganizationModel getById(String var1);

    public OrganizationModel getByDomainName(String var1);

    default public Stream<OrganizationModel> getAllStream() {
        return this.getAllStream("", null, null, null);
    }

    public Stream<OrganizationModel> getAllStream(String var1, Boolean var2, Integer var3, Integer var4);

    public Stream<OrganizationModel> getAllStream(Map<String, String> var1, Integer var2, Integer var3);

    public boolean remove(OrganizationModel var1);

    public void removeAll();

    public boolean addManagedMember(OrganizationModel var1, UserModel var2);

    public boolean addMember(OrganizationModel var1, UserModel var2);

    @Deprecated(forRemoval=true, since="26")
    public Stream<UserModel> getMembersStream(OrganizationModel var1, String var2, Boolean var3, Integer var4, Integer var5);

    default public Stream<UserModel> getMembersStream(OrganizationModel organization, Map<String, String> filters, Boolean exact, Integer first, Integer max) {
        Stream<UserModel> result = this.getMembersStream(organization, (String)Optional.ofNullable(filters).orElse(Map.of()).get("keycloak.session.realm.users.query.search"), exact, first, max);
        MembershipType membershipType = Optional.ofNullable(filters.get("membershipType")).map(MembershipType::valueOf).orElse(null);
        if (membershipType != null) {
            return result.filter(userModel -> MembershipType.MANAGED.equals((Object)membershipType) ? this.isManagedMember(organization, (UserModel)userModel) : !this.isManagedMember(organization, (UserModel)userModel));
        }
        return result;
    }

    public long getMembersCount(OrganizationModel var1);

    public UserModel getMemberById(OrganizationModel var1, String var2);

    public Stream<OrganizationModel> getByMember(UserModel var1);

    public boolean addIdentityProvider(OrganizationModel var1, IdentityProviderModel var2);

    public Stream<IdentityProviderModel> getIdentityProviders(OrganizationModel var1);

    public boolean removeIdentityProvider(OrganizationModel var1, IdentityProviderModel var2);

    public boolean isEnabled();

    public boolean isManagedMember(OrganizationModel var1, UserModel var2);

    default public boolean isMember(OrganizationModel organization, UserModel user) {
        return this.getMemberById(organization, user.getId()) != null;
    }

    public boolean removeMember(OrganizationModel var1, UserModel var2);

    public long count();

    default public OrganizationModel getByAlias(String alias) {
        return this.getAllStream(Map.of("alias", alias), 0, 1).findAny().orElse(null);
    }
}

