/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.paths;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import xsbt.boot.internal.shaded.coursier.paths.CoursierPaths;

public class Mirror {
    private final List<String> from;
    private final String to;
    private final String type;

    public static Mirror of(List<String> list, String string, String string2) {
        return new Mirror(list, string, string2);
    }

    public static File[] defaultConfigFiles() throws IOException {
        String object = System.getenv("COURSIER_MIRRORS");
        if (object != null && !object.isEmpty()) {
            return new File[]{new File(object)};
        }
        String string = System.getProperty("xsbt.boot.internal.shaded.coursier.mirrors");
        if (string != null && !string.isEmpty()) {
            return new File[]{new File(string)};
        }
        File[] fileArray = CoursierPaths.configDirectories();
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            file = new File(file, "mirror.properties");
            arrayList.add(file);
        }
        ArrayList<File> arrayList2 = arrayList;
        return arrayList2.toArray(new File[arrayList2.size()]);
    }

    public static File extraConfigFile() throws IOException {
        String string = System.getenv("COURSIER_EXTRA_MIRRORS");
        if (string != null) {
            return new File(string);
        }
        string = System.getProperty("xsbt.boot.internal.shaded.coursier.mirrors.extra");
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    public static List<Mirror> parse(File serializable) throws MirrorPropertiesException, IOException {
        Properties properties = new Properties();
        Object object = new FileInputStream((File)serializable);
        Throwable throwable = null;
        try {
            properties.load((InputStream)object);
        }
        catch (Throwable throwable2) {
            try {
                serializable = throwable2;
                throwable = throwable2;
                throw serializable;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((FileInputStream)object).close();
        try {
            object = Mirror.parse(properties);
        }
        catch (MirrorPropertiesException mirrorPropertiesException) {
            throw new MirrorPropertiesException("Parsing " + serializable, mirrorPropertiesException);
        }
        return object;
    }

    public static List<Mirror> parse(Properties properties) throws MirrorPropertiesException {
        Object object = new ArrayList<String>();
        for (Object iterator2 : properties.keySet()) {
            if (!(iterator2 instanceof String) || !((String)iterator2).endsWith(".to")) continue;
            object.add((String)iterator2);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string;
            object = (String)iterator.next();
            String string2 = ((String)object).substring(0, ((String)object).length() - 3);
            Object object2 = properties.getProperty(string2 + ".from");
            if (object2 == null) {
                throw new MirrorPropertiesException("Property " + string2 + ".from not found");
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string3 : ((String)object2).split(Pattern.quote(";"))) {
                if (string3.isEmpty()) continue;
                String string4 = string3;
                if (string4.charAt(string4.length() - 1) == '/') {
                    arrayList2.add(string3.substring(0, string3.length() - 1));
                    continue;
                }
                arrayList2.add(string3);
            }
            object2 = properties.getProperty((String)object);
            if (((String)object2).endsWith("/")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            if (!"maven".equals(string = properties.getProperty(string2 + ".type", "tree")) && !"tree".equals(string)) {
                throw new MirrorPropertiesException("Invalid value for property " + string2 + ".type");
            }
            arrayList.add(Mirror.of(arrayList2, (String)object2, string));
        }
        return arrayList;
    }

    private Mirror(List<String> list, String string, String string2) {
        this.from = Collections.unmodifiableList(new ArrayList<String>(list));
        this.to = string;
        this.type = string2;
    }

    public List<String> from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public String type() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Mirror) {
            object = (Mirror)object;
            return this.from.equals(((Mirror)object).from) && this.to.equals(((Mirror)object).to) && this.type.equals(((Mirror)object).type);
        }
        return false;
    }

    public int hashCode() {
        int n = 17 + "Mirror".hashCode();
        n = n * 37 + this.from.hashCode();
        n = n * 37 + this.to.hashCode();
        n = n * 37 + this.type.hashCode();
        return n * 37;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Mirror(");
        stringBuilder.append("from=List(");
        boolean bl = true;
        for (String string : this.from) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("), to=");
        stringBuilder.append(this.to);
        stringBuilder.append(", type=");
        stringBuilder.append(this.type);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static class MirrorPropertiesException
    extends Exception {
        public MirrorPropertiesException(String string) {
            super(string);
        }

        public MirrorPropertiesException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

