/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.text.NumberFormat;
import org.graalvm.visualvm.heapviewer.model.Bundle;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.lib.ui.Formatters;

public class ProgressNode
extends TextNode {
    private static NumberFormat PERCENT_FORMAT;
    private String progressText;

    public ProgressNode() {
        this(Bundle.ProgressNode_Computing());
    }

    public ProgressNode(String text) {
        this(text, null);
    }

    public ProgressNode(Progress progress) {
        this(Bundle.ProgressNode_Computing(), progress);
    }

    public ProgressNode(String text, Progress progress) {
        super(text);
        if (progress != null) {
            progress.addChangeListener(new Progress.Listener(){

                @Override
                public void progressChanged(Progress.Event e) {
                    ProgressNode.this.progressText = ProgressNode.this.getProgressText(e);
                    RootNode root = RootNode.get(ProgressNode.this);
                    if (root != null) {
                        root.refreshNode(root);
                    }
                }
            });
        }
    }

    public String getProgressText() {
        return this.progressText;
    }

    protected String getProgressText(Progress.Event e) {
        if (e.isKnownSteps()) {
            if (e.isFinished()) {
                return ProgressNode.formatPercent(e.getTotalSteps(), e.getTotalSteps());
            }
            return ProgressNode.formatPercent(e.getCurrentStep(), e.getTotalSteps());
        }
        if (e.isFinished()) {
            return Bundle.ProgressNode_DoneProcessing(ProgressNode.formatNumber(e.getCurrentStep()));
        }
        return Bundle.ProgressNode_Processing(ProgressNode.formatNumber(e.getCurrentStep()));
    }

    protected static String formatNumber(long number) {
        return Formatters.numberFormat().format(number);
    }

    protected static String formatPercent(long value, long maxValue) {
        if (value == maxValue) {
            return Bundle.ProgressNode_Done100pc();
        }
        if (value == 0L) {
            return Bundle.ProgressNode_Done0pc();
        }
        if (PERCENT_FORMAT == null) {
            PERCENT_FORMAT = NumberFormat.getPercentInstance();
            PERCENT_FORMAT.setMaximumFractionDigits(0);
            PERCENT_FORMAT.setMinimumFractionDigits(0);
        }
        return Bundle.ProgressNode_DoneProcessingPc(PERCENT_FORMAT.format((float)value / (float)maxValue), ProgressNode.formatNumber(value));
    }
}

