/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.NioFiles;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.URLInputStreamFacade;

public class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;
    public static String FS = File.separator;
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    public static String[] getDefaultExcludes() {
        return DirectoryScanner.DEFAULTEXCLUDES;
    }

    public static List<String> getDefaultExcludesAsList() {
        return Arrays.asList(FileUtils.getDefaultExcludes());
    }

    public static String getDefaultExcludesAsString() {
        return StringUtils.join(DirectoryScanner.DEFAULTEXCLUDES, ",");
    }

    public static String byteCountToDisplaySize(int size) {
        String displaySize = size / 0x40000000 > 0 ? String.valueOf(size / 0x40000000) + " GB" : (size / 0x100000 > 0 ? String.valueOf(size / 0x100000) + " MB" : (size / 1024 > 0 ? String.valueOf(size / 1024) + " KB" : String.valueOf(size) + " bytes"));
        return displaySize;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String filename(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    public static String basename(String filename) {
        return FileUtils.basename(filename, FileUtils.extension(filename));
    }

    public static String basename(String filename, String suffix) {
        int lastDot;
        int i = filename.lastIndexOf(File.separator) + 1;
        int n = lastDot = suffix != null && suffix.length() > 0 ? filename.lastIndexOf(suffix) : -1;
        if (lastDot >= 0) {
            return filename.substring(i, lastDot);
        }
        if (i > 0) {
            return filename.substring(i);
        }
        return filename;
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static boolean fileExists(String fileName) {
        File file2 = new File(fileName);
        return file2.exists();
    }

    public static String fileRead(String file2) throws IOException {
        return FileUtils.fileRead(file2, null);
    }

    public static String fileRead(String file2, String encoding2) throws IOException {
        return FileUtils.fileRead(new File(file2), encoding2);
    }

    public static String fileRead(File file2) throws IOException {
        return FileUtils.fileRead(file2, null);
    }

    public static String fileRead(File file2, String encoding2) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (InputStreamReader reader2 = FileUtils.getInputStreamReader(file2, encoding2);){
            int count2;
            char[] b = new char[512];
            while ((count2 = reader2.read(b)) >= 0) {
                buf.append(b, 0, count2);
            }
        }
        return buf.toString();
    }

    private static InputStreamReader getInputStreamReader(File file2, String encoding2) throws IOException {
        if (encoding2 != null) {
            return new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]), encoding2);
        }
        return new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]));
    }

    public static void fileAppend(String fileName, String data2) throws IOException {
        FileUtils.fileAppend(fileName, null, data2);
    }

    public static void fileAppend(String fileName, String encoding2, String data2) throws IOException {
        try (OutputStream out = Files.newOutputStream(Paths.get(fileName, new String[0]), StandardOpenOption.APPEND);){
            if (encoding2 != null) {
                out.write(data2.getBytes(encoding2));
            } else {
                out.write(data2.getBytes());
            }
        }
    }

    public static void fileWrite(String fileName, String data2) throws IOException {
        FileUtils.fileWrite(fileName, null, data2);
    }

    public static void fileWrite(String fileName, String encoding2, String data2) throws IOException {
        File file2 = fileName == null ? null : new File(fileName);
        FileUtils.fileWrite(file2, encoding2, data2);
    }

    public static void fileWrite(File file2, String data2) throws IOException {
        FileUtils.fileWrite(file2, null, data2);
    }

    public static void fileWrite(File file2, String encoding2, String data2) throws IOException {
        try (OutputStreamWriter writer2 = FileUtils.getOutputStreamWriter(file2, encoding2);){
            writer2.write(data2);
        }
    }

    private static OutputStreamWriter getOutputStreamWriter(File file2, String encoding2) throws IOException {
        OutputStream out = Files.newOutputStream(file2.toPath(), new OpenOption[0]);
        if (encoding2 != null) {
            return new OutputStreamWriter(out, encoding2);
        }
        return new OutputStreamWriter(out);
    }

    public static void fileDelete(String fileName) {
        File file2 = new File(fileName);
        try {
            NioFiles.deleteIfExists(file2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static boolean waitFor(String fileName, int seconds) {
        return FileUtils.waitFor(new File(fileName), seconds);
    }

    public static boolean waitFor(File file2, int seconds) {
        int timeout2 = 0;
        int tick = 0;
        while (!file2.exists()) {
            if (tick++ >= 10) {
                tick = 0;
                if (timeout2++ > seconds) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static File getFile(String fileName) {
        return new File(fileName);
    }

    public static String[] getFilesFromExtension(String directory, String[] extensions2) {
        List<String> files = new ArrayList<String>();
        File currentDir = new File(directory);
        String[] unknownFiles = currentDir.list();
        if (unknownFiles == null) {
            return new String[0];
        }
        for (String unknownFile : unknownFiles) {
            String currentFileName = directory + System.getProperty("file.separator") + unknownFile;
            File currentFile = new File(currentFileName);
            if (currentFile.isDirectory()) {
                if (currentFile.getName().equals("CVS")) continue;
                String[] fetchFiles = FileUtils.getFilesFromExtension(currentFileName, extensions2);
                files = FileUtils.blendFilesToVector(files, fetchFiles);
                continue;
            }
            String add = currentFile.getAbsolutePath();
            if (!FileUtils.isValidFile(add, extensions2)) continue;
            files.add(add);
        }
        return files.toArray(new String[0]);
    }

    private static List<String> blendFilesToVector(List<String> v, String[] files) {
        for (String file2 : files) {
            v.add(file2);
        }
        return v;
    }

    private static boolean isValidFile(String file2, String[] extensions2) {
        String extension = FileUtils.extension(file2);
        if (extension == null) {
            extension = "";
        }
        for (String extension1 : extensions2) {
            if (!extension1.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static void mkdir(String dir2) {
        File file2 = new File(dir2);
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file2)) {
            throw new IllegalArgumentException("The file (" + dir2 + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            return false;
        }
        try (InputStream input1 = Files.newInputStream(file1.toPath(), new OpenOption[0]);){
            boolean bl;
            block15: {
                InputStream input2 = Files.newInputStream(file2.toPath(), new OpenOption[0]);
                try {
                    bl = IOUtil.contentEquals(input1, input2);
                    if (input2 == null) break block15;
                }
                catch (Throwable throwable) {
                    if (input2 != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input2.close();
            }
            return bl;
        }
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = -1;
        while ((pos = filename.indexOf(37, pos + 1)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public static URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }

    public static String removeExtension(String filename) {
        String ext = FileUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index2 = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index2);
    }

    public static String getExtension(String filename) {
        return FileUtils.extension(filename);
    }

    public static String removePath(String filepath) {
        return FileUtils.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index2 = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index2) {
            return filepath;
        }
        return filepath.substring(index2 + 1);
    }

    public static String getPath(String filepath) {
        return FileUtils.getPath(filepath, File.separatorChar);
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index2 = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index2) {
            return "";
        }
        return filepath.substring(0, index2);
    }

    public static void copyFileToDirectory(String source2, String destinationDirectory) throws IOException {
        FileUtils.copyFileToDirectory(new File(source2), new File(destinationDirectory));
    }

    public static void copyFileToDirectoryIfModified(String source2, String destinationDirectory) throws IOException {
        FileUtils.copyFileToDirectoryIfModified(new File(source2), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source2, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFile(source2, new File(destinationDirectory, source2.getName()));
    }

    public static void copyFileToDirectoryIfModified(File source2, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFileIfModified(source2, new File(destinationDirectory, source2.getName()));
    }

    public static void mkDirs(File sourceBase, String[] dirs, File destination) throws IOException {
        for (String dir2 : dirs) {
            File src = new File(sourceBase, dir2);
            File dst = new File(destination, dir2);
            if (NioFiles.isSymbolicLink(src)) {
                File target = NioFiles.readSymbolicLink(src);
                NioFiles.createSymbolicLink(dst, target);
                continue;
            }
            dst.mkdirs();
        }
    }

    public static void copyFile(File source2, File destination) throws IOException {
        if (!source2.exists()) {
            String message = "File " + source2 + " does not exist";
            throw new IOException(message);
        }
        if (source2.getCanonicalPath().equals(destination.getCanonicalPath())) {
            return;
        }
        FileUtils.mkdirsFor(destination);
        FileUtils.doCopyFile(source2, destination);
        if (source2.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source2 + " to " + destination;
            throw new IOException(message);
        }
    }

    private static void doCopyFile(File source2, File destination) throws IOException {
        FileUtils.doCopyFileUsingNewIO(source2, destination);
    }

    private static void doCopyFileUsingNewIO(File source2, File destination) throws IOException {
        NioFiles.copy(source2, destination);
    }

    public static void linkFile(File source2, File destination) throws IOException {
        if (!source2.exists()) {
            String message = "File " + source2 + " does not exist";
            throw new IOException(message);
        }
        if (source2.getCanonicalPath().equals(destination.getCanonicalPath())) {
            return;
        }
        FileUtils.mkdirsFor(destination);
        NioFiles.createSymbolicLink(destination, source2);
    }

    public static boolean copyFileIfModified(File source2, File destination) throws IOException {
        if (FileUtils.isSourceNewerThanDestination(source2, destination)) {
            FileUtils.copyFile(source2, destination);
            return true;
        }
        return false;
    }

    public static void copyURLToFile(URL source2, File destination) throws IOException {
        FileUtils.copyStreamToFile(new URLInputStreamFacade(source2), destination);
    }

    public static void copyStreamToFile(InputStreamFacade source2, File destination) throws IOException {
        FileUtils.mkdirsFor(destination);
        FileUtils.checkCanWrite(destination);
        try (InputStream input = source2.getInputStream();
             OutputStream output = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
            IOUtil.copy(input, output);
        }
    }

    private static void checkCanWrite(File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
    }

    private static void mkdirsFor(File destination) {
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    public static String normalize(String path2) {
        int index2;
        String normalized = path2;
        while ((index2 = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index2) + normalized.substring(index2 + 1);
        }
        while ((index2 = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index2) + normalized.substring(index2 + 2);
        }
        while ((index2 = normalized.indexOf("/../")) >= 0) {
            if (index2 == 0) {
                return null;
            }
            int index22 = normalized.lastIndexOf(47, index2 - 1);
            normalized = normalized.substring(0, index22) + normalized.substring(index2 + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path2) {
        int index2 = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index2);
        String pth = path2;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index2 = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index2);
            index2 = pth.indexOf("../") + 3;
            pth = pth.substring(index2);
        }
        return new StringBuffer(lookup).append("/").append(pth).toString();
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator) || Os.isFamily("windows") && filenm.indexOf(":") > 0) {
            File file2 = new File(filenm);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file2;
        }
        char[] chars2 = filename.toCharArray();
        StringBuilder sb = new StringBuilder();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars2.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars2[i] && File.separatorChar == chars2[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars2[i]);
        }
        filenm = sb.toString();
        File file3 = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file3;
    }

    public static void forceDelete(String file2) throws IOException {
        FileUtils.forceDelete(new File(file2));
    }

    public static void forceDelete(File file2) throws IOException {
        if (file2.isDirectory()) {
            FileUtils.deleteDirectory(file2);
        } else {
            boolean filePresent = file2.getCanonicalFile().exists();
            if (!FileUtils.deleteFile(file2) && filePresent) {
                String message = "File " + file2 + " unable to be deleted.";
                throw new IOException(message);
            }
        }
    }

    private static boolean deleteFile(File file2) throws IOException {
        if (file2.isDirectory()) {
            throw new IOException("File " + file2 + " isn't a file.");
        }
        if (!file2.delete()) {
            if (Os.isFamily("windows")) {
                file2 = file2.getCanonicalFile();
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return file2.delete();
            }
            catch (InterruptedException ignore) {
                return file2.delete();
            }
        }
        return true;
    }

    public static void forceDeleteOnExit(File file2) throws IOException {
        if (!file2.exists()) {
            return;
        }
        if (file2.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file2);
        } else {
            file2.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        directory.deleteOnExit();
        FileUtils.cleanDirectoryOnExit(directory);
    }

    private static void cleanDirectoryOnExit(File directory) throws IOException {
        File[] files;
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        for (File file2 : files = directory.listFiles()) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceMkdir(File file2) throws IOException {
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file2)) {
            throw new IllegalArgumentException("The file (" + file2.getAbsolutePath() + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (file2.exists()) {
            if (file2.isFile()) {
                String message = "File " + file2 + " exists and is not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file2.mkdirs()) {
            String message = "Unable to create directory " + file2;
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (directory.delete()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtils.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static long sizeOfDirectory(String directory) {
        return FileUtils.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(File directory) {
        File[] files;
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        for (File file2 : files = directory.listFiles()) {
            if (file2.isDirectory()) {
                size += FileUtils.sizeOfDirectory(file2);
                continue;
            }
            size += file2.length();
        }
        return size;
    }

    public static List<File> getFiles(File directory, String includes, String excludes) throws IOException {
        return FileUtils.getFiles(directory, includes, excludes, true);
    }

    public static List<File> getFiles(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        List<String> fileNames = FileUtils.getFileNames(directory, includes, excludes, includeBasedir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : fileNames) {
            files.add(new File(filename));
        }
        return files;
    }

    public static List<String> getFileNames(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getFileNames(directory, includes, excludes, includeBasedir, true);
    }

    public static List<String> getFileNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, true, false);
    }

    public static List<String> getDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getDirectoryNames(directory, includes, excludes, includeBasedir, true);
    }

    public static List<String> getDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, false, true);
    }

    public static List<String> getFileAndDirectoryNames(File directory, String includes, String excludes, boolean includeBasedir, boolean isCaseSensitive, boolean getFiles, boolean getDirectories) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (includes != null) {
            scanner.setIncludes(StringUtils.split(includes, ","));
        }
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split(excludes, ","));
        }
        scanner.setCaseSensitive(isCaseSensitive);
        scanner.scan();
        ArrayList<String> list = new ArrayList<String>();
        if (getFiles) {
            String[] files;
            for (String file2 : files = scanner.getIncludedFiles()) {
                if (includeBasedir) {
                    list.add(directory + FS + file2);
                    continue;
                }
                list.add(file2);
            }
        }
        if (getDirectories) {
            String[] directories = scanner.getIncludedDirectories();
            for (String directory1 : directories) {
                if (includeBasedir) {
                    list.add(directory + FS + directory1);
                    continue;
                }
                list.add(directory1);
            }
        }
        return list;
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectory(sourceDirectory, destinationDirectory, "**", null);
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List<File> files = FileUtils.getFiles(sourceDirectory, includes, excludes);
        for (File file2 : files) {
            FileUtils.copyFileToDirectory(file2, destinationDirectory);
        }
    }

    public static void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, String[] includes, String[] excludes) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        if (includes != null && includes.length >= 1) {
            scanner.setIncludes(includes);
        } else {
            scanner.setIncludes(new String[]{"**"});
        }
        if (excludes != null && excludes.length >= 1) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedDirectories = Arrays.asList(scanner.getIncludedDirectories());
        for (String name2 : includedDirectories) {
            File source2 = new File(sourceDirectory, name2);
            if (source2.equals(sourceDirectory)) continue;
            File destination = new File(destinationDirectory, name2);
            destination.mkdirs();
        }
    }

    public static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, false);
    }

    public static void copyDirectoryStructureIfModified(File sourceDirectory, File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, true);
    }

    private static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, File rootDestinationDirectory, boolean onlyModifiedFiles) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file2 : files) {
            if (file2.equals(rootDestinationDirectory)) continue;
            String dest = file2.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file2.isFile()) {
                destination = destination.getParentFile();
                if (onlyModifiedFiles) {
                    FileUtils.copyFileToDirectoryIfModified(file2, destination);
                    continue;
                }
                FileUtils.copyFileToDirectory(file2, destination);
                continue;
            }
            if (file2.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file2, destination, rootDestinationDirectory, onlyModifiedFiles);
                continue;
            }
            throw new IOException("Unknown file type: " + file2.getAbsolutePath());
        }
    }

    public static void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            FileUtils.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String prefix, String suffix, File parentDir) {
        Random rand2;
        File result = null;
        String parent = System.getProperty("java.io.tmpdir");
        if (parentDir != null) {
            parent = parentDir.getPath();
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        SecureRandom secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        Random random2 = rand2 = new Random(secureInitializer + Runtime.getRuntime().freeMemory());
        synchronized (random2) {
            while ((result = new File(parent, prefix + fmt.format(Math.abs(rand2.nextInt())) + suffix)).exists()) {
            }
        }
        return result;
    }

    public static void copyFile(File from, File to, String encoding2, FilterWrapper[] wrappers) throws IOException {
        FileUtils.copyFile(from, to, encoding2, wrappers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to, String encoding2, FilterWrapper[] wrappers, boolean overwrite) throws IOException {
        block7: {
            block6: {
                if (wrappers == null || wrappers.length <= 0) break block6;
                BufferedReader fileReader = null;
                Writer fileWriter = null;
                try {
                    if (encoding2 == null || encoding2.length() < 1) {
                        fileReader = Files.newBufferedReader(from.toPath());
                        fileWriter = Files.newBufferedWriter(to.toPath(), new OpenOption[0]);
                    } else {
                        OutputStream outstream = Files.newOutputStream(to.toPath(), new OpenOption[0]);
                        fileReader = Files.newBufferedReader(from.toPath(), Charset.forName(encoding2));
                        fileWriter = new OutputStreamWriter(outstream, encoding2);
                    }
                    Reader reader2 = fileReader;
                    for (FilterWrapper wrapper : wrappers) {
                        reader2 = wrapper.getReader(reader2);
                    }
                    IOUtil.copy(reader2, fileWriter);
                    fileWriter.close();
                    fileWriter = null;
                    ((Reader)fileReader).close();
                    fileReader = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileReader);
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                break block7;
            }
            if (FileUtils.isSourceNewerThanDestination(from, to) || overwrite) {
                FileUtils.copyFile(from, to);
            }
        }
    }

    private static boolean isSourceNewerThanDestination(File source2, File destination) {
        return destination.lastModified() == 0L && source2.lastModified() == 0L || destination.lastModified() < source2.lastModified();
    }

    public static List<String> loadFile(File file2) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (file2.exists()) {
            try (BufferedReader reader2 = Files.newBufferedReader(file2.toPath());){
                String line = reader2.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                        lines.add(line);
                    }
                    line = reader2.readLine();
                }
            }
        }
        return lines;
    }

    public static boolean isValidWindowsFileName(File f) {
        if (Os.isFamily("windows")) {
            if (StringUtils.indexOfAny(f.getName(), INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME) != -1) {
                return false;
            }
            File parentFile = f.getParentFile();
            if (parentFile != null) {
                return FileUtils.isValidWindowsFileName(parentFile);
            }
        }
        return true;
    }

    public static abstract class FilterWrapper {
        public abstract Reader getReader(Reader var1);
    }
}

