/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.trans.XPathException;

public class OneOrMore<T extends Item>
extends ZeroOrMore<T> {
    public OneOrMore(T[] content) {
        super(Arrays.asList(content));
        if (content.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public OneOrMore(List<T> content) {
        super(content);
        if (content.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    public static OneOrMore<Item> makeOneOrMore(Sequence sequence) throws XPathException {
        ArrayList content = new ArrayList();
        SequenceTool.supply(sequence.iterate(), it -> content.add(it));
        if (content.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new OneOrMore<Item>(content);
    }
}

