/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.xsite.statetransfer.StateTransferStatus;

class StatusResponseCollector
extends ValidResponseCollector<Map<String, StateTransferStatus>>
implements BiConsumer<String, StateTransferStatus> {
    private final Map<String, StateTransferStatus> result = new HashMap<String, StateTransferStatus>();
    private Exception exception;

    StatusResponseCollector() {
    }

    @Override
    public Map<String, StateTransferStatus> finish() {
        if (this.exception != null) {
            throw CompletableFutures.asCompletionException((Throwable)this.exception);
        }
        return this.result;
    }

    @Override
    protected Map<String, StateTransferStatus> addValidResponse(Address sender, ValidResponse response) {
        Map rsp = (Map)response.getResponseValue();
        rsp.forEach(this);
        return null;
    }

    @Override
    protected Map<String, StateTransferStatus> addTargetNotFound(Address sender) {
        return null;
    }

    @Override
    protected Map<String, StateTransferStatus> addException(Address sender, Exception exception) {
        this.recordException(exception);
        return null;
    }

    private void recordException(Exception e) {
        if (this.exception == null) {
            this.exception = e;
        } else {
            this.exception.addSuppressed(e);
        }
    }

    @Override
    public void accept(String site, StateTransferStatus status) {
        this.result.merge(site, status, StateTransferStatus::merge);
    }
}

