/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import java.util.Objects;

public final class InstrumentationUtil {
    private static final ContextKey<Boolean> SUPPRESS_INSTRUMENTATION_KEY = ContextKey.named((String)"suppress_internal_exporter_instrumentation");

    private InstrumentationUtil() {
    }

    public static void suppressInstrumentation(Runnable runnable) {
        Context.current().with(SUPPRESS_INSTRUMENTATION_KEY, (Object)true).wrap(runnable).run();
    }

    public static boolean shouldSuppressInstrumentation(Context context) {
        return Objects.equals(context.get(SUPPRESS_INSTRUMENTATION_KEY), true);
    }
}

