/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.AuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.StaticResourcesConfig;
import io.quarkus.vertx.http.runtime.TrafficShapingConfig;
import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class HttpConfiguration {
    @ConfigDocSection(generated=true)
    public AuthRuntimeConfig auth;
    @ConfigItem(name="cors")
    public boolean corsEnabled;
    @ConfigItem(defaultValue="8080")
    public int port;
    @ConfigItem(defaultValue="8081")
    public int testPort;
    @ConfigItem
    public String host;
    @ConfigItem
    public Optional<String> testHost;
    @ConfigItem(defaultValue="true")
    public boolean hostEnabled;
    @ConfigItem(defaultValue="8443")
    public int sslPort;
    @ConfigItem(defaultValue="8444")
    public int testSslPort;
    @ConfigItem
    public Optional<Boolean> testSslEnabled;
    @ConfigItem
    public Optional<InsecureRequests> insecureRequests;
    @ConfigItem(defaultValue="true")
    public boolean http2;
    @ConfigItem(defaultValue="true")
    public boolean http2PushEnabled;
    @ConfigDocSection(generated=true)
    public CORSConfig cors;
    public ServerSslConfig ssl;
    @ConfigItem
    public Optional<String> tlsConfigurationName;
    @ConfigDocSection(generated=true)
    public StaticResourcesConfig staticResources;
    @ConfigItem(defaultValue="false", name="handle-100-continue-automatically")
    public boolean handle100ContinueAutomatically;
    @ConfigItem
    public OptionalInt ioThreads;
    @ConfigDocSection(generated=true)
    public ServerLimitsConfig limits;
    @ConfigItem(defaultValue="30M", name="idle-timeout")
    public Duration idleTimeout;
    @ConfigItem(defaultValue="60s", name="read-timeout")
    public Duration readTimeout;
    public BodyConfig body;
    @ConfigItem(name="auth.session.encryption-key")
    public Optional<String> encryptionKey;
    @ConfigItem
    public boolean soReusePort;
    @ConfigItem
    public boolean tcpQuickAck;
    @ConfigItem
    public boolean tcpCork;
    @ConfigItem
    public boolean tcpFastOpen;
    @ConfigItem(defaultValue="-1")
    public int acceptBacklog;
    @ConfigItem
    public OptionalInt initialWindowSize;
    @ConfigItem(defaultValue="/var/run/io.quarkus.app.socket")
    public String domainSocket;
    @ConfigItem
    public boolean domainSocketEnabled;
    @ConfigItem
    public boolean recordRequestStartTime;
    @ConfigDocSection(generated=true)
    public AccessLogConfig accessLog;
    @ConfigDocSection
    public TrafficShapingConfig trafficShaping;
    @ConfigItem
    public Map<String, SameSiteCookieConfig> sameSiteCookie;
    @ConfigItem
    public Optional<PayloadHint> unhandledErrorContentTypeDefault;
    @ConfigItem
    @ConfigDocSection(generated=true)
    public Map<String, HeaderConfig> header;
    @ConfigItem
    @ConfigDocSection(generated=true)
    public Map<String, FilterConfig> filter;
    @ConfigDocSection
    public ProxyConfig proxy;

    public int determinePort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testPort : this.port;
    }

    public int determineSslPort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testSslPort : this.sslPort;
    }

    public static enum PayloadHint {
        JSON,
        HTML,
        TEXT;

    }

    public static enum InsecureRequests {
        ENABLED,
        REDIRECT,
        DISABLED;

    }
}

