/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.stat.SessionStatistics;

public class SessionStatisticsImpl
implements SessionStatistics {
    private final @UnknownKeyFor @NonNull @Initialized SessionImplementor session;

    public SessionStatisticsImpl(@UnknownKeyFor @NonNull @Initialized SessionImplementor session) {
        this.session = session;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getEntityCount() {
        return this.session.getPersistenceContextInternal().getNumberOfManagedEntities();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getCollectionCount() {
        return this.session.getPersistenceContextInternal().getCollectionEntriesSize();
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getEntityKeys() {
        return Collections.unmodifiableSet(this.session.getPersistenceContextInternal().getEntitiesByKey().keySet());
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getCollectionKeys() {
        return Collections.unmodifiableSet(this.session.getPersistenceContextInternal().getCollectionsByKey().keySet());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SessionStatistics[entity count=" + this.getEntityCount() + ",collection count=" + this.getCollectionCount() + "]";
    }
}

