/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import org.logstash.plugins.pipeline.PipelineInput;

public final class ReceiveResponse {
    private final PipelineInput.ReceiveStatus status;
    private final Integer sequencePosition;
    private final Throwable cause;

    public static ReceiveResponse closing() {
        return new ReceiveResponse(PipelineInput.ReceiveStatus.CLOSING);
    }

    public static ReceiveResponse completed() {
        return new ReceiveResponse(PipelineInput.ReceiveStatus.COMPLETED);
    }

    public static ReceiveResponse failedAt(int sequencePosition, Throwable cause) {
        return new ReceiveResponse(PipelineInput.ReceiveStatus.FAIL, sequencePosition, cause);
    }

    private ReceiveResponse(PipelineInput.ReceiveStatus status) {
        this(status, null);
    }

    private ReceiveResponse(PipelineInput.ReceiveStatus status, Integer sequencePosition) {
        this(status, sequencePosition, null);
    }

    private ReceiveResponse(PipelineInput.ReceiveStatus status, Integer sequencePosition, Throwable cause) {
        this.status = status;
        this.sequencePosition = sequencePosition;
        this.cause = cause;
    }

    public PipelineInput.ReceiveStatus getStatus() {
        return this.status;
    }

    public Integer getSequencePosition() {
        return this.sequencePosition;
    }

    public boolean wasSuccess() {
        return this.status == PipelineInput.ReceiveStatus.COMPLETED;
    }

    public String getCauseMessage() {
        return this.cause != null ? this.cause.getMessage() : "UNDEFINED ERROR";
    }
}

