/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;
import tr.view.actions.screens.filters.FilterDate;
import tr.view.filters.FilterComboDate;

public class FilterDateScheduleFrom
extends FilterDate
implements PropertyChangeListener {
    public static final byte INDEX = 20;
    private static final DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.YESTERDAY, DateItem.WEEKS_AGO_1, DateItem.WEEKS_AGO_2, DateItem.WEEKS_AGO_3, DateItem.WEEKS_AGO_4};

    public FilterDateScheduleFrom() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new FilterComboDate(dateItems, false);
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-schedule-from");
    }

    public byte getIndex() {
        return 20;
    }

    public void propertyChange(PropertyChangeEvent e) {
        DateItem item = (DateItem)this.combo.getSelectedItem();
        if (item == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new FromDateMatcher(FilterComboDate.getDate((DateItem)item), this.excludeNulls));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FromDateMatcher
    implements Matcher<Action> {
        private final Date matchDate;
        private final boolean excludeNulls;

        public FromDateMatcher(Date date, boolean excludeNulls) {
            this.matchDate = DateUtils.getStart((Date)date);
            this.excludeNulls = excludeNulls;
        }

        public boolean matches(Action action) {
            if (this.matchDate == null) {
                return true;
            }
            if (!action.isStateScheduled()) {
                return false;
            }
            ActionStateScheduled state = (ActionStateScheduled)action.getState();
            Date date = state.getDate();
            if (date == null) {
                return !this.excludeNulls;
            }
            return !date.before(this.matchDate);
        }
    }
}

