/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class GoSafeFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        char marker = (char)buf.getByte(buf.readerIndex());
        if (marker == '*') {
            int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)35);
            if (index != -1) {
                return buf.readRetainedSlice(index + 1 - buf.readerIndex());
            }
        } else {
            int index = buf.indexOf(buf.readerIndex() + 1, buf.writerIndex(), (byte)-8);
            if (index >= 0) {
                ByteBuf result = Unpooled.buffer((int)(index + 1 - buf.readerIndex()));
                while (buf.readerIndex() <= index) {
                    short b = buf.readUnsignedByte();
                    if (b == 27) {
                        short ext = buf.readUnsignedByte();
                        if (ext == 0) {
                            result.writeByte(27);
                            continue;
                        }
                        if (ext != 227) continue;
                        result.writeByte(248);
                        continue;
                    }
                    result.writeByte((int)b);
                }
                return result;
            }
        }
        return null;
    }
}

