/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class SpecificationVersion
implements Comparable<SpecificationVersion> {
    private static final Map<String, int[]> parseCache = new HashMap<String, int[]>(200);
    private final int[] digits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecificationVersion(String string) throws NumberFormatException {
        Map<String, int[]> map = parseCache;
        synchronized (map) {
            int[] nArray = parseCache.get(string);
            if (nArray == null) {
                nArray = SpecificationVersion.parse(string);
                parseCache.put(string.intern(), nArray);
            }
            this.digits = nArray;
        }
    }

    private static int[] parse(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens();
        if (n % 2 == 0) {
            throw new NumberFormatException("Even number of pieces in a spec version: `" + string + "'");
        }
        int[] nArray = new int[n / 2 + 1];
        int n2 = 0;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                bl = false;
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (n3 < 0) {
                    throw new NumberFormatException("Spec version component <0: " + n3);
                }
                nArray[n2++] = n3;
                continue;
            }
            if (!".".equals(stringTokenizer.nextToken())) {
                throw new NumberFormatException("Expected dot in spec version: `" + string + "'");
            }
            bl = true;
        }
        return nArray;
    }

    @Override
    public int compareTo(SpecificationVersion specificationVersion) {
        int[] nArray = specificationVersion.digits;
        int n = this.digits.length;
        int n2 = nArray.length;
        int n3 = Math.max(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = i < n ? this.digits[i] : 0;
            int n6 = n4 = i < n2 ? nArray[i] : 0;
            if (n5 == n4) continue;
            return n5 - n4;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpecificationVersion)) {
            return false;
        }
        return Arrays.equals(this.digits, ((SpecificationVersion)object).digits);
    }

    public int hashCode() {
        int n = 925295;
        int n2 = this.digits.length;
        for (int i = 0; i < n2; ++i) {
            n ^= this.digits[i] << i;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.digits.length * 3 + 1);
        for (int i = 0; i < this.digits.length; ++i) {
            if (i > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(this.digits[i]);
        }
        return stringBuilder.toString();
    }
}

