/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantXMLQuery
extends VariantAbstractRPCQuery {
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String XML_APP_CONTENT_TYPE = "application/xml";
    public static final String SOAP2_CONTENT_TYPE = "application/soap+xml";
    private static final String attRegex = "(\\S+)\\s*=\\s*((?:\"[^\"\\&\\<]*\")|(?:'[^'\\&\\<]*'))";
    private static final String tagRegex = "\\<([\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*)\\s*[^\\>]*\\>((?:\\<\\!\\[CDATA\\[(?:.(?<!\\]\\]>))*\\]\\]>)|(?:[^\\<\\&]*))\\<\\/[\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*\\s*\\>";
    private Pattern attPattern = Pattern.compile("(\\S+)\\s*=\\s*((?:\"[^\"\\&\\<]*\")|(?:'[^'\\&\\<]*'))");
    private Pattern tagPattern = Pattern.compile("\\<([\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*)\\s*[^\\>]*\\>((?:\\<\\!\\[CDATA\\[(?:.(?<!\\]\\]>))*\\]\\]>)|(?:[^\\<\\&]*))\\<\\/[\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*\\s*\\>");

    @Override
    public boolean isValidContentType(String contentType) {
        return contentType.startsWith(XML_CONTENT_TYPE) || contentType.startsWith(SOAP2_CONTENT_TYPE) || contentType.startsWith(XML_APP_CONTENT_TYPE);
    }

    @Override
    public String getEscapedValue(String value, boolean toQuote) {
        return StringEscapeUtils.escapeXml(value);
    }

    @Override
    public String getUnescapedValue(String value) {
        return StringEscapeUtils.unescapeXml(value);
    }

    @Override
    public void parseContent(String content) {
        int eidx;
        int bidx;
        Matcher matcher = this.attPattern.matcher(content);
        while (matcher.find()) {
            bidx = matcher.start(2) + 1;
            eidx = matcher.end(2) - 1;
            this.addParameter(matcher.group(1), bidx, eidx, false, false);
        }
        matcher = this.tagPattern.matcher(content);
        while (matcher.find()) {
            String value = matcher.group(2);
            bidx = matcher.start(2);
            eidx = matcher.end(2);
            value = value.startsWith("<![CDATA[") && value.endsWith("]]>") ? value.substring(9, value.length() - 3) : this.getUnescapedValue(value);
            this.addParameter(matcher.group(1), bidx, eidx, false, value);
        }
    }
}

