/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.transform.InstanceStateStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class InstanceStateChangeStaxUnmarshaller
implements Unmarshaller<InstanceStateChange, StaxUnmarshallerContext> {
    private static InstanceStateChangeStaxUnmarshaller instance;

    public InstanceStateChange unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStateChange instanceStateChange = new InstanceStateChange();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceStateChange;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("instanceId", targetDepth)) {
                    instanceStateChange.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("currentState", targetDepth)) {
                    instanceStateChange.setCurrentState(InstanceStateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("previousState", targetDepth)) continue;
                instanceStateChange.setPreviousState(InstanceStateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceStateChange;
    }

    public static InstanceStateChangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStateChangeStaxUnmarshaller();
        }
        return instance;
    }
}

