/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.tokenizer;

import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPTokenType;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.Serializable;

public final class JBBPToken
implements Serializable {
    private static final long serialVersionUID = 7864654729087070154L;
    private final JBBPTokenType type;
    private final String fieldName;
    private final String arraySize;
    private final JBBPFieldTypeParameterContainer fieldTypeParameters;
    private final int position;

    JBBPToken(JBBPTokenType type, int position, JBBPFieldTypeParameterContainer fieldTypeParameters, String arrayLength, String fieldName) {
        JBBPUtils.assertNotNull((Object)type, "Type must not be null");
        this.type = type;
        this.position = position;
        this.fieldTypeParameters = fieldTypeParameters;
        this.fieldName = fieldName;
        this.arraySize = arrayLength;
    }

    public int getPosition() {
        return this.position;
    }

    public JBBPTokenType getType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JBBPFieldTypeParameterContainer getFieldTypeParameters() {
        return this.fieldTypeParameters;
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public boolean isComment() {
        return this.type == JBBPTokenType.COMMENT;
    }

    public boolean isVarArrayLength() {
        return this.isArray() && !JBBPUtils.isNumber(this.arraySize);
    }

    public String getArraySizeAsString() {
        return this.arraySize;
    }

    public Integer getArraySizeAsInt() {
        if (this.arraySize == null) {
            throw new NullPointerException("Array size is not defined");
        }
        try {
            return Integer.valueOf(this.arraySize.trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type.name()).append(' ');
        if (this.fieldTypeParameters != null) {
            result.append(this.fieldTypeParameters).append(' ');
        }
        if (this.arraySize != null) {
            result.append('[').append(this.arraySize).append("] ");
        }
        if (this.fieldName != null) {
            result.append(this.fieldName);
        }
        if (this.type != JBBPTokenType.COMMENT) {
            result.append(';');
        }
        return result.toString();
    }
}

