/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private static Lookup.Result<StatusLineElementProvider> result;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Rectangle forcedBounds = null;
    private Image waitingForPaintDummyImage;
    private Graphics waitingForPaintDummyGraphic;
    boolean isOlderJDK = System.getProperty("java.version").startsWith("1.5");
    private boolean isFullScreenMode = false;
    private Rectangle restoreBounds;
    private int restoreExtendedState = 0;
    private boolean isSwitchingFullScreenMode = false;
    private boolean isUndecorated = true;
    private int windowDecorationStyle = 1;

    @Override
    protected void setRootPane(JRootPane jRootPane) {
        super.setRootPane(jRootPane);
        if (jRootPane != null) {
            HelpCtx.setHelpIDString((JComponent)jRootPane, (String)new HelpCtx(MainWindow.class).getHelpID());
        }
        jRootPane.setOpaque(true);
        if (Utilities.isWindows()) {
            JPanel jPanel = new JPanel(){

                public void setVisible(boolean bl) {
                    if (bl != this.isVisible()) {
                        super.setVisible(bl);
                    }
                }
            };
            jPanel.setName(jRootPane.getName() + ".nbGlassPane");
            jPanel.setVisible(false);
            ((JPanel)jPanel).setOpaque(false);
            jRootPane.setGlassPane(jPanel);
        }
    }

    public void initializeComponents() {
        JComponent jComponent;
        if (this.inited) {
            return;
        }
        this.inited = true;
        MainWindow.initFrameIcons(this);
        this.initListeners();
        this.setDefaultCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainWindow.class).getString("ACSD_MainWindow"));
        this.setJMenuBar(MainWindow.createMenuBar());
        if (!Constants.NO_TOOLBARS) {
            jComponent = MainWindow.getToolbarComponent();
            this.getContentPane().add((Component)jComponent, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                jComponent = new StatusLine();
                ((JLabel)jComponent).setText(" ");
                jComponent.setPreferredSize(new Dimension(0, jComponent.getPreferredSize().height));
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel jPanel = new JPanel(new BorderLayout());
                int n = 0;
                if (Utilities.isMac()) {
                    n = 12;
                }
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, n), jPanel.getBorder()));
                jPanel.add((Component)new JSeparator(), "North");
                jPanel.add((Component)jComponent, "Center");
                MainWindow.decoratePanel(jPanel);
                jPanel.setName("statusLine");
                this.getContentPane().add((Component)jPanel, "South");
            } else {
                jComponent = MainWindow.getCustomStatusLine();
                if (jComponent != null) {
                    this.getContentPane().add((Component)jComponent, "South");
                }
            }
        }
        this.getContentPane().add((Component)this.getDesktopPanel(), "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] == MainWindow.this.getJMenuBar() && !MainWindow.this.isActive()) {
                    MainWindow.this.toFront();
                }
            }
        });
        this.setTitle(NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)System.getProperty("netbeans.buildnumber")));
    }

    private static void decoratePanel(JPanel jPanel) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must run in AWT queue.";
        if (innerIconsPanel != null) {
            jPanel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(jPanel)) != null) {
            jPanel.add((Component)innerIconsPanel, "East");
        }
    }

    static JPanel getStatusLineElements(JPanel jPanel) {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(jPanel));
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return null;
        }
        Iterator iterator = collection.iterator();
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        boolean bl = false;
        while (iterator.hasNext()) {
            StatusLineElementProvider statusLineElementProvider = (StatusLineElementProvider)iterator.next();
            Component component = statusLineElementProvider.getStatusLineElement();
            if (component == null) continue;
            bl = true;
            jPanel2.add(component);
        }
        return bl ? jPanel2 : null;
    }

    private static Border getDesktopBorder() {
        Border border = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (border != null) {
            return border;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    private static Image createIDEImage() {
        return ImageUtilities.loadImage((String)ICON_16, (boolean)true);
    }

    private static List<Image> createIDEImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(ImageUtilities.loadImage((String)ICON_16, (boolean)true));
        arrayList.add(ImageUtilities.loadImage((String)ICON_32, (boolean)true));
        arrayList.add(ImageUtilities.loadImage((String)ICON_48, (boolean)true));
        return arrayList;
    }

    static void initFrameIcons(Frame frame) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.awt.Window");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Method method = null;
        try {
            method = clazz.getMethod("setIconImages", List.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            List<Image> list = MainWindow.createIDEImages();
            try {
                method.invoke((Object)frame, list);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(MainWindow.class.getName()).log(Level.INFO, "Cannot invoke setIconImages", illegalAccessException);
                frame.setIconImage(MainWindow.createIDEImage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(MainWindow.class.getName()).log(Level.INFO, "Cannot invoke setIconImages", invocationTargetException);
                frame.setIconImage(MainWindow.createIDEImage());
            }
        } else {
            frame.setIconImage(MainWindow.createIDEImage());
        }
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LifecycleManager.getDefault().exit();
            }

            public void windowActivated(WindowEvent windowEvent) {
                RegistryImpl.cancelMenu(MainWindow.this);
            }
        });
    }

    private static JMenuBar createMenuBar() {
        JMenuBar jMenuBar = MainWindow.getCustomMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new MenuBar(null);
        }
        jMenuBar.setBorderPainted(false);
        if (jMenuBar instanceof MenuBar) {
            ((MenuBar)jMenuBar).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine statusLine = new StatusLine();
                JSeparator jSeparator = new JSeparator(1);
                Dimension dimension = jSeparator.getPreferredSize();
                dimension.width += 6;
                jSeparator.setPreferredSize(dimension);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jSeparator, "West");
                jPanel.add((Component)statusLine, "Center");
                MainWindow.decoratePanel(jPanel);
                jPanel.setName("statusLine");
                jMenuBar.add(jPanel);
            } else {
                JComponent jComponent = MainWindow.getCustomStatusLine();
                if (jComponent != null) {
                    jMenuBar.add(jComponent);
                }
            }
        }
        return jMenuBar;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_MENU_BAR_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_STATUS_LINE_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        toolbarPool.waitFinished();
        return toolbarPool;
    }

    private void initializeBounds() {
        Rectangle rectangle = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (null != this.forcedBounds) {
            rectangle = new Rectangle(this.forcedBounds);
            this.setPreferredSize(rectangle.getSize());
            this.forcedBounds = null;
        }
        if (!rectangle.isEmpty()) {
            this.setBounds(rectangle);
        }
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component component) {
        if (this.desktop == component) {
            if (this.desktop != null && !Arrays.asList(this.getDesktopPanel().getComponents()).contains(this.desktop)) {
                this.getDesktopPanel().add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.getDesktopPanel().remove(this.desktop);
        }
        this.desktop = component;
        if (this.desktop != null) {
            this.getDesktopPanel().add(this.desktop, "Center");
        }
        this.invalidate();
        this.validate();
        if (this.isOlderJDK && !System.getProperty("os.name").startsWith("Windows")) {
            this.releaseWaitingForPaintDummyGraphic();
        }
        this.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    private JPanel getDesktopPanel() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new JPanel();
            this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
            this.desktopPanel.setLayout(new BorderLayout());
        }
        return this.desktopPanel;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle rectangle = this.getBounds();
        if (this.desktop != null) {
            Dimension dimension = this.desktop.getSize();
            rectangle.height -= dimension.height;
        }
        return rectangle;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.isOlderJDK) {
            this.waitingForPaintDummyImage = new BufferedImage(1, 1, 1);
            this.waitingForPaintDummyGraphic = this.waitingForPaintDummyImage.getGraphics();
        }
        super.setVisible(bl);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.waitingForPaintDummyGraphic != null) {
            this.releaseWaitingForPaintDummyGraphic();
            graphics = this.getGraphics();
        }
        super.paint(graphics);
        Logger.getLogger(MainWindow.class.getName()).log(Level.FINE, "Paint method of main window invoked normally.");
        WindowManagerImpl.getInstance().mainWindowPainted();
    }

    @Override
    public Graphics getGraphics() {
        if (this.waitingForPaintDummyGraphic != null) {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent == null || aWTEvent.getID() != 800 && aWTEvent.getSource() != this) {
                return this.waitingForPaintDummyGraphic;
            }
            this.releaseWaitingForPaintDummyGraphic();
        }
        return super.getGraphics();
    }

    private void releaseWaitingForPaintDummyGraphic() {
        if (this.waitingForPaintDummyGraphic != null) {
            this.waitingForPaintDummyGraphic.dispose();
            this.waitingForPaintDummyGraphic = null;
            this.waitingForPaintDummyImage = null;
        }
    }

    public void setFullScreenMode(boolean bl) {
        Object object;
        ToolbarConfiguration toolbarConfiguration;
        if (this.isFullScreenMode == bl || this.isSwitchingFullScreenMode) {
            return;
        }
        this.isSwitchingFullScreenMode = true;
        if (!this.isFullScreenMode) {
            this.restoreExtendedState = this.getExtendedState();
            this.restoreBounds = this.getBounds();
            this.isUndecorated = this.isUndecorated();
            this.windowDecorationStyle = this.getRootPane().getWindowDecorationStyle();
        }
        this.isFullScreenMode = bl;
        if (Utilities.isWindows()) {
            this.setVisible(false);
        } else {
            WindowManagerImpl.getInstance().setVisible(false);
        }
        this.dispose();
        this.setUndecorated(this.isFullScreenMode || this.isUndecorated);
        this.getRootPane().setWindowDecorationStyle(this.isFullScreenMode ? 0 : this.windowDecorationStyle);
        final String string = ToolbarPool.getDefault().getConfiguration();
        if (null != string && null != (toolbarConfiguration = ToolbarConfiguration.findConfiguration(string))) {
            toolbarConfiguration.rebuildMenu();
        }
        MainWindow.getToolbarComponent().setVisible(!this.isFullScreenMode);
        final boolean bl2 = !this.isFullScreenMode;
        GraphicsDevice graphicsDevice = null;
        Graphics graphics = this.getGraphics();
        if (graphics instanceof Graphics2D && null != (object = ((Graphics2D)graphics).getDeviceConfiguration())) {
            graphicsDevice = ((GraphicsConfiguration)object).getDevice();
        }
        if (null != graphicsDevice && graphicsDevice.isFullScreenSupported()) {
            graphicsDevice.setFullScreenWindow(this.isFullScreenMode ? this : null);
        } else {
            this.setExtendedState(this.isFullScreenMode ? 6 : this.restoreExtendedState);
        }
        if (bl2 || this.isFullScreenMode() && !Utilities.isWindows()) {
            if (bl2) {
                this.forcedBounds = this.restoreBounds;
            } else {
                object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.forcedBounds = ((GraphicsEnvironment)object).getMaximumWindowBounds();
            }
        }
        if (Utilities.isWindows()) {
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    if (bl2) {
                        MainWindow.this.setPreferredSize(MainWindow.this.restoreBounds.getSize());
                        MainWindow.this.setBounds(MainWindow.this.restoreBounds);
                    }
                    ToolbarPool.getDefault().setConfiguration(string);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                }
            });
        } else {
            WindowManagerImpl.getInstance().setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    ToolbarPool.getDefault().setConfiguration(string);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                }
            });
        }
    }

    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel jPanel) {
            this.decoratingPanel = jPanel;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel);
                }
            });
        }
    }
}

