"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceBlockedKeywords = exports.WINDOW = exports.TRIGGER_TYPE = exports.SECURITY_CONSTANTS = exports.SCHEDULE_TYPE = exports.REPORT_TYPE = exports.REPORT_STATE = exports.REPORT_DEFINITION_STATUS = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.FORMAT = exports.EXTRA_HEADERS = exports.DELIVERY_TYPE = exports.DELIVERY_CHANNEL = exports.DEFAULT_ROLLING_COUNTER = exports.DEFAULT_MAX_SIZE = exports.DATA_REPORT_CONFIG = exports.CAPACITY = exports.ALLOWED_HOSTS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let FORMAT = exports.FORMAT = /*#__PURE__*/function (FORMAT) {
  FORMAT["pdf"] = "pdf";
  FORMAT["png"] = "png";
  FORMAT["csv"] = "csv";
  FORMAT["xlsx"] = "xlsx";
  return FORMAT;
}({});
let REPORT_STATE = exports.REPORT_STATE = /*#__PURE__*/function (REPORT_STATE) {
  REPORT_STATE["created"] = "Created";
  REPORT_STATE["error"] = "Error";
  REPORT_STATE["pending"] = "Pending";
  REPORT_STATE["shared"] = "Shared";
  return REPORT_STATE;
}({});
let REPORT_DEFINITION_STATUS = exports.REPORT_DEFINITION_STATUS = /*#__PURE__*/function (REPORT_DEFINITION_STATUS) {
  REPORT_DEFINITION_STATUS["active"] = "Active";
  REPORT_DEFINITION_STATUS["disabled"] = "Disabled";
  return REPORT_DEFINITION_STATUS;
}({});
let DELIVERY_CHANNEL = exports.DELIVERY_CHANNEL = /*#__PURE__*/function (DELIVERY_CHANNEL) {
  DELIVERY_CHANNEL["email"] = "Email";
  DELIVERY_CHANNEL["slack"] = "Slack";
  DELIVERY_CHANNEL["chime"] = "Chime";
  DELIVERY_CHANNEL["opensearchDashboards"] = "OpenSearch Dashboards user";
  return DELIVERY_CHANNEL;
}({});
let SCHEDULE_TYPE = exports.SCHEDULE_TYPE = /*#__PURE__*/function (SCHEDULE_TYPE) {
  SCHEDULE_TYPE["recurring"] = "Recurring";
  SCHEDULE_TYPE["cron"] = "Cron based";
  return SCHEDULE_TYPE;
}({});
let REPORT_TYPE = exports.REPORT_TYPE = /*#__PURE__*/function (REPORT_TYPE) {
  REPORT_TYPE["savedSearch"] = "Saved search";
  REPORT_TYPE["dashboard"] = "Dashboard";
  REPORT_TYPE["visualization"] = "Visualization";
  REPORT_TYPE["notebook"] = "Notebook";
  return REPORT_TYPE;
}({});
let DATA_REPORT_CONFIG = exports.DATA_REPORT_CONFIG = /*#__PURE__*/function (DATA_REPORT_CONFIG) {
  DATA_REPORT_CONFIG["excelDateFormat"] = "MM/DD/YYYY h:mm:ss.SSS a";
  return DATA_REPORT_CONFIG;
}({});
let TRIGGER_TYPE = exports.TRIGGER_TYPE = /*#__PURE__*/function (TRIGGER_TYPE) {
  TRIGGER_TYPE["schedule"] = "Schedule";
  TRIGGER_TYPE["onDemand"] = "On demand";
  return TRIGGER_TYPE;
}({});
let DELIVERY_TYPE = exports.DELIVERY_TYPE = /*#__PURE__*/function (DELIVERY_TYPE) {
  DELIVERY_TYPE["opensearchDashboardsUser"] = "OpenSearch Dashboards user";
  DELIVERY_TYPE["channel"] = "Channel";
  return DELIVERY_TYPE;
}({}); // https://www.elastic.co/guide/en/elasticsearch/reference/6.8/search-request-from-size.html
const DEFAULT_MAX_SIZE = exports.DEFAULT_MAX_SIZE = 10000;
const SECURITY_CONSTANTS = exports.SECURITY_CONSTANTS = {
  TENANT_LOCAL_STORAGE_KEY: 'opendistro::security::tenant::show_popup'
};
const EXTRA_HEADERS = exports.EXTRA_HEADERS = ['cookie', 'x-proxy-user', 'x-proxy-roles', 'x-forwarded-for'];
const BLOCKED_KEYWORD = 'BLOCKED_KEYWORD';
const ipv4Regex = /(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?):([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const ipv6Regex = /(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))/g;
const localhostRegex = /localhost:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const iframeRegex = /iframe/g;
const ALLOWED_HOSTS = exports.ALLOWED_HOSTS = /^(0|0.0.0.0|127.0.0.1|localhost|(.*\.)?(opensearch.org|aws.a2z.com))$/;
const replaceBlockedKeywords = htmlString => {
  // replace <ipv4>:<port>
  htmlString = htmlString.replace(ipv4Regex, BLOCKED_KEYWORD);
  // replace ipv6 addresses
  htmlString = htmlString.replace(ipv6Regex, BLOCKED_KEYWORD);
  // replace iframe keyword
  htmlString = htmlString.replace(iframeRegex, BLOCKED_KEYWORD);
  // replace localhost:<port>
  htmlString = htmlString.replace(localhostRegex, BLOCKED_KEYWORD);
  return htmlString;
};

/**
 * Metric constants
 */
exports.replaceBlockedKeywords = replaceBlockedKeywords;
const WINDOW = exports.WINDOW = 3600;
const INTERVAL = exports.INTERVAL = 60;
const CAPACITY = exports.CAPACITY = WINDOW / INTERVAL * 2;
const GLOBAL_BASIC_COUNTER = exports.GLOBAL_BASIC_COUNTER = {
  report: {
    create: {
      total: 0
    },
    create_from_definition: {
      total: 0
    },
    download: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    }
  },
  report_definition: {
    create: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    },
    update: {
      total: 0
    },
    delete: {
      total: 0
    }
  },
  report_source: {
    list: {
      total: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        total: 0
      }
    },
    xlsx: {
      download: {
        total: 0
      }
    }
  }
};
const DEFAULT_ROLLING_COUNTER = exports.DEFAULT_ROLLING_COUNTER = {
  report: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    create_from_definition: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    download: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_definition: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    update: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    delete: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_source: {
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        count: 0
      }
    },
    xlsx: {
      download: {
        count: 0
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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