/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl.basic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acl.basic.AbstractBasicAclEntry;
import org.springframework.security.acl.basic.AclObjectIdentity;

public class SimpleAclEntry
extends AbstractBasicAclEntry {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$acl$basic$SimpleAclEntry == null ? (class$org$springframework$security$acl$basic$SimpleAclEntry = SimpleAclEntry.class$("org.springframework.security.acl.basic.SimpleAclEntry")) : class$org$springframework$security$acl$basic$SimpleAclEntry));
    public static final int NOTHING = 0;
    public static final int ADMINISTRATION = (int)Math.pow(2.0, 0.0);
    public static final int READ = (int)Math.pow(2.0, 1.0);
    public static final int WRITE = (int)Math.pow(2.0, 2.0);
    public static final int CREATE = (int)Math.pow(2.0, 3.0);
    public static final int DELETE = (int)Math.pow(2.0, 4.0);
    public static final int READ_WRITE_CREATE_DELETE = READ | WRITE | CREATE | DELETE;
    public static final int READ_WRITE_CREATE = READ | WRITE | CREATE;
    public static final int READ_WRITE = READ | WRITE;
    public static final int READ_WRITE_DELETE = READ | WRITE | DELETE;
    private static final int[] VALID_PERMISSIONS = new int[]{0, ADMINISTRATION, READ, WRITE, CREATE, DELETE, READ_WRITE_CREATE_DELETE, READ_WRITE_CREATE, READ_WRITE, READ_WRITE_DELETE};
    private static final String[] VALID_PERMISSIONS_AS_STRING = new String[]{"NOTHING", "ADMINISTRATION", "READ", "WRITE", "CREATE", "DELETE", "READ_WRITE_CREATE_DELETE", "READ_WRITE_CREATE", "READ_WRITE", "READ_WRITE_DELETE"};
    static /* synthetic */ Class class$org$springframework$security$acl$basic$SimpleAclEntry;

    public SimpleAclEntry() {
    }

    public SimpleAclEntry(Object recipient, AclObjectIdentity aclObjectIdentity, AclObjectIdentity aclObjectParentIdentity, int mask) {
        super(recipient, aclObjectIdentity, aclObjectParentIdentity, mask);
    }

    public int[] getValidPermissions() {
        return (int[])VALID_PERMISSIONS.clone();
    }

    public String printPermissionsBlock(int i) {
        StringBuffer sb = new StringBuffer();
        if (this.isPermitted(i, ADMINISTRATION)) {
            sb.append('A');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, READ)) {
            sb.append('R');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, WRITE)) {
            sb.append('W');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, CREATE)) {
            sb.append('C');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, DELETE)) {
            sb.append('D');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static int parsePermission(String permission) {
        for (int i = 0; i < VALID_PERMISSIONS_AS_STRING.length; ++i) {
            if (!VALID_PERMISSIONS_AS_STRING[i].equalsIgnoreCase(permission)) continue;
            return VALID_PERMISSIONS[i];
        }
        throw new IllegalArgumentException("Permission provided does not exist: " + permission);
    }

    public static int[] parsePermissions(String[] permissions) {
        int[] requirepermissionAsIntArray = new int[permissions.length];
        for (int i = 0; i < requirepermissionAsIntArray.length; ++i) {
            requirepermissionAsIntArray[i] = SimpleAclEntry.parsePermission(permissions[i]);
        }
        return requirepermissionAsIntArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

