/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.DisplayName;

public abstract class DefaultNativeComponent {
    private final ConfigurableFileCollection source;

    public DefaultNativeComponent(ObjectFactory objectFactory) {
        this.source = objectFactory.fileCollection();
    }

    public abstract DisplayName getDisplayName();

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.source);
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    protected FileCollection createSourceView(final String defaultLocation, List<String> sourceExtensions) {
        final PatternSet patternSet = new PatternSet();
        for (String sourceExtension : sourceExtensions) {
            patternSet.include(new String[]{"**/*." + sourceExtension});
        }
        return this.getProjectLayout().files(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                FileTree tree = DefaultNativeComponent.this.source.getFrom().isEmpty() ? DefaultNativeComponent.this.getProjectLayout().getProjectDirectory().dir(defaultLocation).getAsFileTree() : DefaultNativeComponent.this.source.getAsFileTree();
                return tree.matching((PatternFilterable)patternSet);
            }
        }});
    }
}

