/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import java.text.ParseException;

public class HostNameParser
extends ParserCore {
    private static boolean stripAddressScopeZones = false;
    private static final char[] VALID_DOMAIN_LABEL_CHAR;

    public HostNameParser(String hname) {
        this.lexer = new LexerCore("charLexer", hname);
    }

    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
    }

    protected void consumeDomainLabel() throws ParseException {
        if (debug) {
            this.dbg_enter("domainLabel");
        }
        try {
            this.lexer.consumeValidChars(VALID_DOMAIN_LABEL_CHAR);
        }
        finally {
            if (debug) {
                this.dbg_leave("domainLabel");
            }
        }
    }

    protected String ipv6Reference() throws ParseException {
        StringBuilder retval = new StringBuilder();
        if (debug) {
            this.dbg_enter("ipv6Reference");
        }
        try {
            if (stripAddressScopeZones) {
                while (this.lexer.hasMoreChars()) {
                    char la = this.lexer.lookAhead(0);
                    if (!LexerCore.isHexDigit(la) && la != '.' && la != ':' && la != '[') {
                        if (la == ']') {
                            this.lexer.consume(1);
                            retval.append(la);
                            String string = retval.toString();
                            return string;
                        }
                        if (la == '%') {
                            int stripLen;
                            this.lexer.consume(1);
                            String rest = this.lexer.getRest();
                            if (rest != null && rest.length() != 0 && (stripLen = rest.indexOf(93)) != -1) {
                                this.lexer.consume(stripLen + 1);
                                retval.append("]");
                                String string = retval.toString();
                                return string;
                            }
                        }
                        break;
                    }
                    this.lexer.consume(1);
                    retval.append(la);
                }
            } else {
                while (this.lexer.hasMoreChars()) {
                    char la = this.lexer.lookAhead(0);
                    if (!LexerCore.isHexDigit(la) && la != '.' && la != ':' && la != '[') {
                        if (la == ']') {
                            this.lexer.consume(1);
                            retval.append(la);
                            String string = retval.toString();
                            return string;
                        }
                        break;
                    }
                    this.lexer.consume(1);
                    retval.append(la);
                }
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        finally {
            if (debug) {
                this.dbg_leave("ipv6Reference");
            }
        }
    }

    public Host host() throws ParseException {
        if (debug) {
            this.dbg_enter("host");
        }
        try {
            int startPtr;
            String hostname;
            if (this.lexer.lookAhead(0) == '[') {
                hostname = this.ipv6Reference();
            } else if (this.isIPv6Address(this.lexer.getRest())) {
                startPtr = this.lexer.getPtr();
                this.lexer.consumeValidChars(new char[]{'\ufffd', ':'});
                hostname = "[" + this.lexer.getBuffer().substring(startPtr, this.lexer.getPtr()) + "]";
            } else {
                startPtr = this.lexer.getPtr();
                this.consumeDomainLabel();
                hostname = this.lexer.getBuffer().substring(startPtr, this.lexer.getPtr());
            }
            if (hostname.length() == 0) {
                throw new ParseException(this.lexer.getBuffer() + ": Missing host name", this.lexer.getPtr());
            }
            Host host = new Host(hostname);
            return host;
        }
        finally {
            if (debug) {
                this.dbg_leave("host");
            }
        }
    }

    private boolean isIPv6Address(String uriHeader) {
        String host;
        int firstColonIndex;
        String hostName = uriHeader;
        int indexOfComma = uriHeader.indexOf(",");
        if (indexOfComma != -1) {
            hostName = uriHeader.substring(0, indexOfComma);
        }
        int hostEnd = hostName.indexOf(63);
        int semiColonIndex = hostName.indexOf(59);
        if (hostEnd == -1 || semiColonIndex != -1 && hostEnd > semiColonIndex) {
            hostEnd = semiColonIndex;
        }
        if (hostEnd == -1) {
            hostEnd = hostName.length();
        }
        if ((firstColonIndex = (host = hostName.substring(0, hostEnd)).indexOf(58)) == -1) {
            return false;
        }
        int secondColonIndex = host.indexOf(58, firstColonIndex + 1);
        return secondColonIndex != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort(boolean allowWS) throws ParseException {
        if (debug) {
            this.dbg_enter("hostPort");
        }
        try {
            Host host = this.host();
            HostPort hp = new HostPort();
            hp.setHost(host);
            if (allowWS) {
                this.lexer.SPorHT();
            }
            if (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                switch (la) {
                    case ':': {
                        this.lexer.consume(1);
                        if (allowWS) {
                            this.lexer.SPorHT();
                        }
                        try {
                            String port2 = this.lexer.number();
                            hp.setPort(Integer.parseInt(port2));
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case '/': 
                    case ';': 
                    case '>': 
                    case '?': {
                        break;
                    }
                    case '%': {
                        if (stripAddressScopeZones) break;
                    }
                    default: {
                        if (allowWS) break;
                        throw new ParseException(this.lexer.getBuffer() + " Illegal character in hostname:" + this.lexer.lookAhead(0), this.lexer.getPtr());
                    }
                }
            }
            HostPort hostPort = hp;
            return hostPort;
        }
        finally {
            if (debug) {
                this.dbg_leave("hostPort");
            }
        }
    }

    public static void main(String[] args2) throws ParseException {
        String[] hostNames = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   ", "MIK_S:1234"};
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                HostNameParser hnp = new HostNameParser(hostNames[i]);
                HostPort hp = hnp.hostPort(true);
                System.out.println("[" + hp.encode() + "]");
                continue;
            }
            catch (ParseException ex) {
                System.out.println("exception text = " + ex.getMessage());
            }
        }
    }

    static {
        stripAddressScopeZones = Boolean.getBoolean("gov.nist.core.STRIP_ADDR_SCOPES");
        VALID_DOMAIN_LABEL_CHAR = new char[]{'\ufffd', '-', '.', '_'};
    }
}

