/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class CreateModelFromSetAction
extends ActionType<CreateModelFromSetResponse> {
    public static final String NAME = "cluster:admin/ltr/store/create-model-from-set";
    public static final CreateModelFromSetAction INSTANCE = new CreateModelFromSetAction();

    protected CreateModelFromSetAction() {
        super(NAME, CreateModelFromSetResponse::new);
    }

    public static class CreateModelFromSetResponse
    extends ActionResponse
    implements StatusToXContentObject {
        private static final int VERSION = 1;
        private IndexResponse response;

        public CreateModelFromSetResponse(StreamInput in) throws IOException {
            super(in);
            int version = in.readVInt();
            assert (version == 1);
            this.response = new IndexResponse(in);
        }

        public CreateModelFromSetResponse(IndexResponse response) {
            this.response = response;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(1);
            this.response.writeTo(out);
        }

        public IndexResponse getResponse() {
            return this.response;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.response.toXContent(builder, params);
        }

        public RestStatus status() {
            return this.response.status();
        }
    }

    public static class CreateModelFromSetRequest
    extends ActionRequest {
        private String store;
        private String featureSetName;
        private Long expectedSetVersion;
        private String modelName;
        private StoredLtrModel.LtrModelDefinition definition;
        private String routing;
        private FeatureValidation validation;

        public CreateModelFromSetRequest() {
        }

        public CreateModelFromSetRequest(StreamInput in) throws IOException {
            super(in);
            this.store = in.readString();
            this.featureSetName = in.readString();
            this.expectedSetVersion = in.readOptionalLong();
            this.modelName = in.readString();
            this.definition = new StoredLtrModel.LtrModelDefinition(in);
            this.routing = in.readOptionalString();
            this.validation = (FeatureValidation)in.readOptionalWriteable(FeatureValidation::new);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = null;
            if (this.store == null) {
                arve = ValidateActions.addValidationError((String)"store must be set", null);
            }
            if (this.featureSetName == null) {
                arve = ValidateActions.addValidationError((String)"featureSetName must be set", (ActionRequestValidationException)arve);
            }
            if (this.modelName == null) {
                arve = ValidateActions.addValidationError((String)"modelName must be set", (ActionRequestValidationException)arve);
            }
            if (this.definition == null) {
                arve = ValidateActions.addValidationError((String)"defition must be set", (ActionRequestValidationException)arve);
            }
            return arve;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.store);
            out.writeString(this.featureSetName);
            out.writeOptionalLong(this.expectedSetVersion);
            out.writeString(this.modelName);
            this.definition.writeTo(out);
            out.writeOptionalString(this.routing);
            out.writeOptionalWriteable((Writeable)this.validation);
        }

        public String getStore() {
            return this.store;
        }

        public String getFeatureSetName() {
            return this.featureSetName;
        }

        public String getModelName() {
            return this.modelName;
        }

        public StoredLtrModel.LtrModelDefinition getDefinition() {
            return this.definition;
        }

        public Long getExpectedSetVersion() {
            return this.expectedSetVersion;
        }

        public String getRouting() {
            return this.routing;
        }

        public void setRouting(String routing) {
            this.routing = routing;
        }

        public FeatureValidation getValidation() {
            return this.validation;
        }

        public void setValidation(FeatureValidation validation) {
            this.validation = validation;
        }
    }

    public static class CreateModelFromSetRequestBuilder
    extends ActionRequestBuilder<CreateModelFromSetRequest, CreateModelFromSetResponse> {
        public CreateModelFromSetRequestBuilder(OpenSearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new CreateModelFromSetRequest());
        }

        public CreateModelFromSetRequestBuilder withVersion(String store, String featureSetName, long expectedSetVersion, String modelName, StoredLtrModel.LtrModelDefinition definition) {
            ((CreateModelFromSetRequest)this.request).store = store;
            ((CreateModelFromSetRequest)this.request).featureSetName = featureSetName;
            ((CreateModelFromSetRequest)this.request).expectedSetVersion = expectedSetVersion;
            ((CreateModelFromSetRequest)this.request).modelName = modelName;
            ((CreateModelFromSetRequest)this.request).definition = definition;
            return this;
        }

        public CreateModelFromSetRequestBuilder withoutVersion(String store, String featureSetName, String modelName, StoredLtrModel.LtrModelDefinition definition) {
            ((CreateModelFromSetRequest)this.request).store = store;
            ((CreateModelFromSetRequest)this.request).featureSetName = featureSetName;
            ((CreateModelFromSetRequest)this.request).expectedSetVersion = null;
            ((CreateModelFromSetRequest)this.request).modelName = modelName;
            ((CreateModelFromSetRequest)this.request).definition = definition;
            return this;
        }

        public CreateModelFromSetRequestBuilder routing(String routing) {
            ((CreateModelFromSetRequest)this.request).setRouting(routing);
            return this;
        }
    }
}

