/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.ClearCachesAction;
import com.o19s.es.ltr.action.FeatureStoreAction;
import com.o19s.es.ltr.action.TransportClearCachesAction;
import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import com.o19s.es.ltr.query.ValidatingLtrQueryBuilder;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexAction;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ltr.breaker.LTRCircuitBreakerService;
import org.opensearch.ltr.exception.LimitExceededException;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportFeatureStoreAction
extends HandledTransportAction<FeatureStoreAction.FeatureStoreRequest, FeatureStoreAction.FeatureStoreResponse> {
    private final LtrRankerParserFactory factory;
    private final ClusterService clusterService;
    private final TransportClearCachesAction clearCachesAction;
    private final Client client;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final LTRCircuitBreakerService ltrCircuitBreakerService;
    private final LTRStats ltrStats;

    @Inject
    public TransportFeatureStoreAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, LtrRankerParserFactory factory, TransportClearCachesAction clearCachesAction, LTRCircuitBreakerService ltrCircuitBreakerService, LTRStats ltrStats) {
        super("cluster:admin/ltr/featurestore/data", false, transportService, actionFilters, FeatureStoreAction.FeatureStoreRequest::new);
        this.factory = factory;
        this.clusterService = clusterService;
        this.clearCachesAction = clearCachesAction;
        this.client = client;
        this.ltrCircuitBreakerService = ltrCircuitBreakerService;
        this.ltrStats = ltrStats;
    }

    protected void doExecute(Task task, FeatureStoreAction.FeatureStoreRequest request, ActionListener<FeatureStoreAction.FeatureStoreResponse> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(request.getStore())) {
            throw new IllegalArgumentException("Store [" + request.getStore() + "] does not exist, please create it first.");
        }
        if (this.ltrCircuitBreakerService.isOpen().booleanValue()) {
            throw new LimitExceededException("Store [" + request.getStore() + "] creating/updating features through simple CRUD is not allowed as memory circuit is broken.");
        }
        this.precheck(request);
        if (request.getValidation() != null) {
            this.validate(request.getValidation(), request.getStorableElement(), task, listener, () -> this.store(request, task, listener), this.ltrStats);
        } else {
            this.store(request, task, listener);
        }
    }

    private Optional<ClearCachesAction.ClearCachesNodesRequest> buildClearCache(FeatureStoreAction.FeatureStoreRequest request) throws IOException {
        if (request.getAction() == FeatureStoreAction.FeatureStoreRequest.Action.UPDATE) {
            ClearCachesAction.ClearCachesNodesRequest clearCachesNodesRequest = new ClearCachesAction.ClearCachesNodesRequest();
            switch (request.getStorableElement().type()) {
                case "feature": {
                    clearCachesNodesRequest.clearFeature(request.getStore(), request.getStorableElement().name());
                    return Optional.of(clearCachesNodesRequest);
                }
                case "featureset": {
                    clearCachesNodesRequest.clearFeatureSet(request.getStore(), request.getStorableElement().name());
                    return Optional.of(clearCachesNodesRequest);
                }
            }
        }
        return Optional.empty();
    }

    private IndexRequest buildIndexRequest(Task parentTask, FeatureStoreAction.FeatureStoreRequest request) throws IOException {
        StorableElement elt = request.getStorableElement();
        IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(request.getStore()).setId(elt.id()).setCreate(request.getAction() == FeatureStoreAction.FeatureStoreRequest.Action.CREATE).setRouting(request.getRouting()).setSource(IndexFeatureStore.toSource(elt)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).request();
        indexRequest.setParentTask(this.clusterService.localNode().getId(), parentTask.getId());
        return indexRequest;
    }

    private void precheck(FeatureStoreAction.FeatureStoreRequest request) {
        if (request.getStorableElement() instanceof StoredLtrModel) {
            StoredLtrModel model = (StoredLtrModel)request.getStorableElement();
            try {
                model.compile(this.factory);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error while parsing model [" + model.name() + "] with type [" + model.rankingModelType() + "]", e);
            }
        } else if (request.getStorableElement() instanceof StoredFeatureSet) {
            StoredFeatureSet set = (StoredFeatureSet)request.getStorableElement();
            set.optimize().validate();
        } else if (request.getStorableElement() instanceof StoredFeature) {
            StoredFeature feature = (StoredFeature)request.getStorableElement();
            feature.optimize();
        }
    }

    private void validate(FeatureValidation validation, StorableElement element, Task task, ActionListener<FeatureStoreAction.FeatureStoreResponse> listener, Runnable onSuccess, LTRStats ltrStats) {
        ValidatingLtrQueryBuilder ltrBuilder = new ValidatingLtrQueryBuilder(element, validation, this.factory, ltrStats);
        SearchRequestBuilder builder = new SearchRequestBuilder((OpenSearchClient)this.client, SearchAction.INSTANCE);
        builder.setIndices(new String[]{validation.getIndex()});
        builder.setQuery((QueryBuilder)ltrBuilder);
        builder.setFrom(0);
        builder.setSize(20);
        builder.setTerminateAfter(1000);
        ((SearchRequest)builder.request()).setParentTask(this.clusterService.localNode().getId(), task.getId());
        builder.execute(ActionListener.wrap(r -> {
            if (r.getFailedShards() > 0) {
                ShardSearchFailure failure = r.getShardFailures()[0];
                throw new IllegalArgumentException("Validating the element caused " + r.getFailedShards() + " shard failures, see root cause: " + failure.reason(), failure.getCause());
            }
            onSuccess.run();
        }, e -> listener.onFailure((Exception)new IllegalArgumentException("Cannot store element, validation failed.", (Throwable)e))));
    }

    private void store(FeatureStoreAction.FeatureStoreRequest request, Task task, ActionListener<FeatureStoreAction.FeatureStoreResponse> listener) {
        try {
            Optional<ClearCachesAction.ClearCachesNodesRequest> clearCachesNodesRequest = this.buildClearCache(request);
            IndexRequest indexRequest = this.buildIndexRequest(task, request);
            this.client.execute((ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, ActionListener.wrap(r -> {
                clearCachesNodesRequest.ifPresent(req -> this.clearCachesAction.execute((ActionRequest)req, ActionListener.wrap(r2 -> {}, e -> this.logger.error("Failed to clear cache", (Throwable)e))));
                listener.onResponse((Object)new FeatureStoreAction.FeatureStoreResponse((IndexResponse)r));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (IOException ioe) {
            listener.onFailure((Exception)ioe);
        }
    }
}

