/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.types.BeaconKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials_BeaconKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials_BranchKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials_Decryption;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials_Encryption;

public abstract class Materials {
    private static final TypeDescriptor<Materials> _TYPE = TypeDescriptor.referenceWithInitializer(Materials.class, () -> Materials.Default());
    private static final Materials theDefault = Materials.create_Encryption(EncryptionMaterials.Default());

    public static TypeDescriptor<Materials> _typeDescriptor() {
        return _TYPE;
    }

    public static Materials Default() {
        return theDefault;
    }

    public static Materials create_Encryption(EncryptionMaterials Encryption) {
        return new Materials_Encryption(Encryption);
    }

    public static Materials create_Decryption(DecryptionMaterials Decryption) {
        return new Materials_Decryption(Decryption);
    }

    public static Materials create_BranchKey(BranchKeyMaterials BranchKey) {
        return new Materials_BranchKey(BranchKey);
    }

    public static Materials create_BeaconKey(BeaconKeyMaterials BeaconKey) {
        return new Materials_BeaconKey(BeaconKey);
    }

    public boolean is_Encryption() {
        return this instanceof Materials_Encryption;
    }

    public boolean is_Decryption() {
        return this instanceof Materials_Decryption;
    }

    public boolean is_BranchKey() {
        return this instanceof Materials_BranchKey;
    }

    public boolean is_BeaconKey() {
        return this instanceof Materials_BeaconKey;
    }

    public EncryptionMaterials dtor_Encryption() {
        Materials d = this;
        return ((Materials_Encryption)d)._Encryption;
    }

    public DecryptionMaterials dtor_Decryption() {
        Materials d = this;
        return ((Materials_Decryption)d)._Decryption;
    }

    public BranchKeyMaterials dtor_BranchKey() {
        Materials d = this;
        return ((Materials_BranchKey)d)._BranchKey;
    }

    public BeaconKeyMaterials dtor_BeaconKey() {
        Materials d = this;
        return ((Materials_BeaconKey)d)._BeaconKey;
    }
}

