/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap;

import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.win32.StdCallLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.opensearch.bootstrap.ConsoleCtrlHandler;

final class JNAKernel32Library {
    private static final Logger logger = LogManager.getLogger(JNAKernel32Library.class);
    private List<NativeHandlerCallback> callbacks = new ArrayList<NativeHandlerCallback>();
    public static final int PAGE_NOACCESS = 1;
    public static final int PAGE_GUARD = 256;
    public static final int MEM_COMMIT = 4096;
    static final int JOBOBJECT_BASIC_LIMIT_INFORMATION_CLASS = 2;
    static final int JOB_OBJECT_LIMIT_ACTIVE_PROCESS = 8;

    private JNAKernel32Library() {
        if (Constants.WINDOWS) {
            try {
                Native.register((String)"kernel32");
                logger.debug("windows/Kernel32 library loaded");
            }
            catch (NoClassDefFoundError e) {
                logger.warn("JNA not found. native methods and handlers will be disabled.");
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("unable to link Windows/Kernel32 library. native methods and handlers will be disabled.");
            }
        }
    }

    static JNAKernel32Library getInstance() {
        return Holder.instance;
    }

    boolean addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        NativeHandlerCallback callback;
        boolean result = false;
        if (handler != null && (result = this.SetConsoleCtrlHandler(callback = new NativeHandlerCallback(handler), true))) {
            this.callbacks.add(callback);
        }
        return result;
    }

    List<Object> getCallbacks() {
        return Collections.unmodifiableList(this.callbacks);
    }

    native boolean SetConsoleCtrlHandler(StdCallLibrary.StdCallCallback var1, boolean var2);

    native boolean VirtualLock(Pointer var1, SizeT var2);

    native int VirtualQueryEx(Pointer var1, Pointer var2, MemoryBasicInformation var3, int var4);

    native boolean SetProcessWorkingSetSize(Pointer var1, SizeT var2, SizeT var3);

    native Pointer GetCurrentProcess();

    native boolean CloseHandle(Pointer var1);

    native int GetShortPathNameW(WString var1, char[] var2, int var3);

    native Pointer CreateJobObjectW(Pointer var1, String var2);

    native boolean AssignProcessToJobObject(Pointer var1, Pointer var2);

    native boolean QueryInformationJobObject(Pointer var1, int var2, Pointer var3, int var4, Pointer var5);

    native boolean SetInformationJobObject(Pointer var1, int var2, Pointer var3, int var4);

    private static final class Holder {
        private static final JNAKernel32Library instance = new JNAKernel32Library();

        private Holder() {
        }
    }

    class NativeHandlerCallback
    implements StdCallLibrary.StdCallCallback {
        private final ConsoleCtrlHandler handler;

        NativeHandlerCallback(ConsoleCtrlHandler handler) {
            this.handler = handler;
        }

        public boolean callback(long dwCtrlType) {
            int event = (int)dwCtrlType;
            if (logger.isDebugEnabled()) {
                logger.debug("console control handler receives event [{}@{}]", (Object)event, (Object)dwCtrlType);
            }
            return this.handler.handle(event);
        }
    }

    public static class JOBOBJECT_BASIC_LIMIT_INFORMATION
    extends Structure
    implements Structure.ByReference {
        public long PerProcessUserTimeLimit;
        public long PerJobUserTimeLimit;
        public int LimitFlags;
        public SizeT MinimumWorkingSetSize;
        public SizeT MaximumWorkingSetSize;
        public int ActiveProcessLimit;
        public Pointer Affinity;
        public int PriorityClass;
        public int SchedulingClass;

        protected List<String> getFieldOrder() {
            return Arrays.asList("PerProcessUserTimeLimit", "PerJobUserTimeLimit", "LimitFlags", "MinimumWorkingSetSize", "MaximumWorkingSetSize", "ActiveProcessLimit", "Affinity", "PriorityClass", "SchedulingClass");
        }
    }

    public static class SizeT
    extends IntegerType {
        public SizeT() {
            this(0L);
        }

        SizeT(long value) {
            super(Native.SIZE_T_SIZE, value);
        }
    }

    public static class MemoryBasicInformation
    extends Structure {
        public Pointer BaseAddress;
        public Pointer AllocationBase;
        public NativeLong AllocationProtect;
        public SizeT RegionSize;
        public NativeLong State;
        public NativeLong Protect;
        public NativeLong Type;

        protected List<String> getFieldOrder() {
            return Arrays.asList("BaseAddress", "AllocationBase", "AllocationProtect", "RegionSize", "State", "Protect", "Type");
        }
    }
}

