/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.SearchThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.UpdateThreatIntelAlertStatusRequest;
import org.opensearch.securityanalytics.threatIntel.action.monitor.response.UpdateThreatIntelAlertsStatusResponse;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.ThreatIntelAlertService;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelAlertDto;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportSearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportUpdateThreatIntelAlertStatusAction
extends HandledTransportAction<UpdateThreatIntelAlertStatusRequest, UpdateThreatIntelAlertsStatusResponse>
implements SecureTransportAction {
    private final Client client;
    private final TransportSearchThreatIntelMonitorAction transportSearchThreatIntelMonitorAction;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final ThreatIntelAlertService alertsService;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportUpdateThreatIntelAlertStatusAction.class);

    @Inject
    public TransportUpdateThreatIntelAlertStatusAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Settings settings, NamedXContentRegistry xContentRegistry, Client client, TransportSearchThreatIntelMonitorAction transportSearchThreatIntelMonitorAction1, ThreatIntelAlertService alertsService) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/alerts/status/update", transportService, actionFilters, UpdateThreatIntelAlertStatusRequest::new);
        this.client = client;
        this.transportSearchThreatIntelMonitorAction = transportSearchThreatIntelMonitorAction1;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.alertsService = alertsService;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, UpdateThreatIntelAlertStatusRequest request, ActionListener<UpdateThreatIntelAlertsStatusResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        SearchRequest threatIntelMonitorsSearchRequest = new SearchRequest();
        threatIntelMonitorsSearchRequest.indices(new String[]{".opendistro-alerting-config"});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"monitor.owner", (Object)"security_analytics")));
        boolQueryBuilder.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"monitor.monitor_type", (Object)"ti_doc_level_monitor")));
        threatIntelMonitorsSearchRequest.source(new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder));
        this.transportSearchThreatIntelMonitorAction.execute(new SearchThreatIntelMonitorRequest(threatIntelMonitorsSearchRequest), ActionListener.wrap(searchResponse -> {
            ArrayList<String> monitorIds;
            List<String> list = monitorIds = searchResponse.getHits() == null || searchResponse.getHits().getHits() == null ? new ArrayList<String>() : Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
            if (monitorIds.isEmpty()) {
                log.error("Threat intel monitor not found. No alerts to update");
                listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Threat intel monitor not found. No alerts to update", RestStatus.BAD_REQUEST, new IllegalArgumentException("Threat intel monitor not found. No alerts to update"))));
            }
            this.onSearchMonitorResponse(monitorIds, request, listener);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                log.error("Threat intel monitor not found. No alerts to update");
                listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Threat intel monitor not found. No alerts to update", RestStatus.BAD_REQUEST, new IllegalArgumentException("Threat intel monitor not found. No alerts to update"))));
                return;
            }
            log.error("Failed to update threat intel monitor alerts status", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void onSearchMonitorResponse(List<String> monitorIds, UpdateThreatIntelAlertStatusRequest request, ActionListener<UpdateThreatIntelAlertsStatusResponse> listener) {
        SearchSourceBuilder searchSourceBuilder = TransportUpdateThreatIntelAlertStatusAction.getSearchSourceQueryingForAlertsToUpdate(monitorIds, request, listener);
        this.alertsService.search(searchSourceBuilder, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> {
            ArrayList<ThreatIntelAlert> alerts = new ArrayList<ThreatIntelAlert>();
            if (searchResponse.getHits() == null || searchResponse.getHits().getHits() == null || searchResponse.getHits().getHits().length == 0) {
                log.error("No alerts found to update");
                listener.onFailure((Exception)((Object)new SecurityAnalyticsException("No alerts found to update", RestStatus.BAD_REQUEST, (Exception)new ResourceNotFoundException("No alerts found to update", new Object[0]))));
                return;
            }
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                if (xcp.currentToken() == null) {
                    xcp.nextToken();
                }
                ThreatIntelAlert alert = ThreatIntelAlert.parse(xcp, hit.getVersion(), hit.getSeqNo(), hit.getPrimaryTerm());
                alerts.add(alert);
            }
            this.updateAlerts(monitorIds, alerts, request.getState(), listener);
        }, e -> {
            log.error("Failed to search for threat intel alerts", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private static SearchSourceBuilder getSearchSourceQueryingForAlertsToUpdate(List<String> monitorIds, UpdateThreatIntelAlertStatusRequest request, ActionListener<UpdateThreatIntelAlertsStatusResponse> listener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder monitorIdMatchQuery = QueryBuilders.boolQuery();
        for (String monitorId : monitorIds) {
            monitorIdMatchQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"monitor_id", (Object)monitorId));
        }
        queryBuilder.filter((QueryBuilder)monitorIdMatchQuery);
        BoolQueryBuilder idMatchQuery = QueryBuilders.boolQuery();
        for (String id : request.getAlertIds()) {
            idMatchQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"_id", (Object)id));
        }
        queryBuilder.filter((QueryBuilder)idMatchQuery);
        if (request.getState() == Alert.State.COMPLETED) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"state", (Object)Alert.State.ACKNOWLEDGED.toString()));
        } else if (request.getState() == Alert.State.ACKNOWLEDGED) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"state", (Object)Alert.State.ACTIVE.toString()));
        } else {
            log.error("Threat intel monitor not found. No alerts to update");
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Threat intel monitor not found. No alerts to update", RestStatus.BAD_REQUEST, new IllegalArgumentException("Threat intel monitor not found. No alerts to update"))));
            return null;
        }
        return new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(request.getAlertIds().size());
    }

    private void updateAlerts(List<String> monitorIds, List<ThreatIntelAlert> alerts, Alert.State state, ActionListener<UpdateThreatIntelAlertsStatusResponse> listener) {
        ArrayList<String> failedAlerts = new ArrayList<String>();
        ArrayList<ThreatIntelAlert> alertsToUpdate = new ArrayList<ThreatIntelAlert>();
        for (ThreatIntelAlert alert : alerts) {
            if (this.isValidStateTransitionRequested(alert.getState(), state)) {
                ThreatIntelAlert updatedAlertModel = ThreatIntelAlert.updateStatus(alert, state);
                alertsToUpdate.add(updatedAlertModel);
                continue;
            }
            log.error("Alert {} : updating alert state from {} to {} is not allowed!", (Object)alert.getId(), (Object)alert.getState(), (Object)state);
            failedAlerts.add(alert.getId());
        }
        this.alertsService.bulkIndexEntities(Collections.emptyList(), alertsToUpdate, (ActionListener<Void>)ActionListener.wrap(r -> {
            ArrayList updatedAlerts = new ArrayList();
            SearchSourceBuilder searchSourceQueryingForAlerts = TransportUpdateThreatIntelAlertStatusAction.getSearchSourceQueryingForUpdatedAlerts(monitorIds, alertsToUpdate.stream().map(ThreatIntelAlert::getId).collect(Collectors.toList()));
            this.alertsService.search(searchSourceQueryingForAlerts, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> {
                if (searchResponse.getHits() == null || searchResponse.getHits().getHits() == null || searchResponse.getHits().getHits().length == 0) {
                    log.error("No alerts found to update");
                    listener.onFailure((Exception)((Object)new SecurityAnalyticsException("No alerts found to update", RestStatus.BAD_REQUEST, (Exception)new ResourceNotFoundException("No alerts found to update", new Object[0]))));
                    return;
                }
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    if (xcp.currentToken() == null) {
                        xcp.nextToken();
                    }
                    if (xcp.currentToken() == null) {
                        xcp.nextToken();
                    }
                    ThreatIntelAlert alert = ThreatIntelAlert.parse(xcp, hit.getVersion());
                    updatedAlerts.add(new ThreatIntelAlertDto(alert, hit.getSeqNo(), hit.getPrimaryTerm()));
                }
                listener.onResponse((Object)new UpdateThreatIntelAlertsStatusResponse(updatedAlerts, failedAlerts));
            }, e -> {
                log.error("Failed to fetch the updated alerts to return. Returning empty list for updated alerts although some might have been updated", (Throwable)e);
                listener.onResponse((Object)new UpdateThreatIntelAlertsStatusResponse(Collections.emptyList(), failedAlerts));
            }));
        }, e -> {
            log.error("Failed to bulk update status of threat intel alerts to " + String.valueOf(state), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private static SearchSourceBuilder getSearchSourceQueryingForUpdatedAlerts(List<String> monitorIds, List<String> alertIds) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder monitorIdMatchQuery = QueryBuilders.boolQuery();
        for (String string : monitorIds) {
            monitorIdMatchQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"monitor_id", (Object)string));
        }
        queryBuilder.filter((QueryBuilder)monitorIdMatchQuery);
        BoolQueryBuilder idMatchQuery = QueryBuilders.boolQuery();
        for (String id : alertIds) {
            idMatchQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"_id", (Object)id));
        }
        queryBuilder.filter((QueryBuilder)idMatchQuery);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(alertIds.size());
        return searchSourceBuilder;
    }

    private boolean isValidStateTransitionRequested(Alert.State currState, Alert.State nextState) {
        if (currState.equals((Object)Alert.State.ACKNOWLEDGED) && nextState.equals((Object)Alert.State.COMPLETED)) {
            return true;
        }
        return currState.equals((Object)Alert.State.ACTIVE) && nextState.equals((Object)Alert.State.ACKNOWLEDGED);
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

