/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs;

import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.ThreadPool;

public class MLBatchTaskUpdateJobRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(ScheduledJobRunner.class);
    private static MLBatchTaskUpdateJobRunner INSTANCE;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private MLTaskManager taskManager;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLBatchTaskUpdateJobRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<MLBatchTaskUpdateJobRunner> clazz = MLBatchTaskUpdateJobRunner.class;
        synchronized (MLBatchTaskUpdateJobRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new MLBatchTaskUpdateJobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MLBatchTaskUpdateJobRunner() {
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void initialize(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.initialized = true;
    }

    public void runJob(ScheduledJobParameter scheduledJobParameter, JobExecutionContext jobExecutionContext) {
        if (!this.initialized) {
            throw new AssertionError((Object)"this instance is not initialized");
        }
        LockService lockService = jobExecutionContext.getLockService();
        Runnable runnable = () -> lockService.acquireLock(scheduledJobParameter, jobExecutionContext, ActionListener.wrap(lock -> {
            if (lock == null) {
                return;
            }
            try {
                String jobName = scheduledJobParameter.getName();
                log.info("Starting job execution for job ID: {} at {}", (Object)jobName, (Object)Instant.now());
                log.debug("Running batch task polling job");
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"task_type", (Object)MLTaskType.BATCH_PREDICTION)).must((QueryBuilder)QueryBuilders.termQuery((String)"function_name", (Object)FunctionName.REMOTE)).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.RUNNING)).should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.CANCELLING)));
                sourceBuilder.query((QueryBuilder)boolQuery);
                sourceBuilder.size(100);
                sourceBuilder.fetchSource(new String[]{"_id"}, null);
                SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-task"});
                searchRequest.source(sourceBuilder);
                this.client.search(searchRequest, ActionListener.wrap(response -> {
                    SearchHit[] searchHits;
                    if (response == null || response.getHits() == null || response.getHits().getHits().length == 0) {
                        log.info("No pending tasks found to be polled by the job");
                        return;
                    }
                    for (SearchHit searchHit : searchHits = response.getHits().getHits()) {
                        String taskId = searchHit.getId();
                        log.debug("Starting polling for task: {} at {}", (Object)taskId, (Object)Instant.now());
                        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).isUserInitiatedGetTaskRequest(Boolean.valueOf(false)).build();
                        this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, ActionListener.wrap(taskResponse -> log.info("Updated Task status for taskId: {} at {}", (Object)taskId, (Object)Instant.now()), exception -> log.error("Failed to get task status for task: " + taskId, (Throwable)exception)));
                    }
                }, e -> {
                    if (e instanceof IndexNotFoundException) {
                        log.info("No tasks found to be polled by the job");
                    } else {
                        log.error("Failed to search for tasks to be polled by the job ", (Throwable)e);
                    }
                }));
                log.info("Completed job execution for job ID: {} at {}", (Object)jobName, (Object)Instant.now());
            }
            finally {
                lockService.release(lock, ActionListener.wrap(released -> log.debug("Released lock for job {}", (Object)scheduledJobParameter.getName()), exception -> {
                    throw new IllegalStateException("Failed to release lock.");
                }));
            }
        }, exception -> {
            throw new IllegalStateException("Failed to acquire lock.");
        }));
        this.threadPool.generic().submit(runnable);
    }
}

