/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;

public class ToolHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(ToolHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadDefaultPromptDictFromFile(Class<?> source, String fileName) {
        try (InputStream searchResponseIns = source.getResourceAsStream(fileName);){
            if (searchResponseIns == null) return new HashMap<String, String>();
            String defaultPromptContent = new String(searchResponseIns.readAllBytes(), StandardCharsets.UTF_8);
            Map map = (Map)StringUtils.gson.fromJson(defaultPromptContent, Map.class);
            return map;
        }
        catch (IOException e) {
            log.error("Failed to load default prompt dict from file: {}", (Object)fileName, (Object)e);
        }
        return new HashMap<String, String>();
    }

    public static void extractFieldNamesTypes(Map<String, Object> mappingSource, Map<String, String> fieldsToType, String prefix, boolean includeFields) {
        if (((String)prefix).length() > 0) {
            prefix = (String)prefix + ".";
        }
        for (Map.Entry<String, Object> entry : mappingSource.entrySet()) {
            String fieldType;
            String n = entry.getKey();
            Object v = entry.getValue();
            if (!(v instanceof Map)) continue;
            Map vMap = (Map)v;
            if (vMap.containsKey("type") && !(fieldType = vMap.getOrDefault("type", "")).equals("alias") && !fieldType.equals("object")) {
                fieldsToType.put((String)prefix + n, (String)vMap.get("type"));
            }
            if (vMap.containsKey("properties")) {
                ToolHelper.extractFieldNamesTypes((Map)vMap.get("properties"), fieldsToType, (String)prefix + n, includeFields);
            }
            if (!includeFields || !vMap.containsKey("fields")) continue;
            ToolHelper.extractFieldNamesTypes((Map)vMap.get("fields"), fieldsToType, (String)prefix + n, true);
        }
    }

    public static <T extends ActionResponse> ActionListener<T> getPPLTransportActionListener(ActionListener<TransportPPLQueryResponse> listener) {
        return ActionListener.wrap(r -> listener.onResponse((Object)TransportPPLQueryResponse.fromActionResponse((ActionResponse)r)), arg_0 -> listener.onFailure(arg_0));
    }
}

