/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.panama;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLSessionStats;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Macros;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLSessionContext
implements SSLSessionContext {
    private static final StringManager sm = StringManager.getManager(OpenSSLSessionContext.class);
    private static final Enumeration<byte[]> EMPTY = new EmptyEnumeration();
    private static final int TICKET_KEYS_SIZE = 48;
    private final OpenSSLSessionStats stats;
    private final OpenSSLContext context;

    OpenSSLSessionContext(OpenSSLContext context) {
        this.context = context;
        this.stats = new OpenSSLSessionStats(context.getSSLContext());
    }

    @Override
    public SSLSession getSession(byte[] bytes) {
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    public void setTicketKeys(byte[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException(sm.getString("sessionContext.nullTicketKeys"));
        }
        if (keys.length != 48) {
            throw new IllegalArgumentException(sm.getString("sessionContext.invalidTicketKeysLength", new Object[]{keys.length}));
        }
        try (Arena memorySession = Arena.ofConfined();){
            MemorySegment array = memorySession.allocateFrom(ValueLayout.JAVA_BYTE, keys);
            openssl_h_Macros.SSL_CTX_set_tlsext_ticket_keys(this.context.getSSLContext(), array, 48L);
        }
    }

    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? (long)openssl_h.SSL_SESS_CACHE_SERVER() : (long)openssl_h.SSL_SESS_CACHE_OFF();
        openssl_h_Macros.SSL_CTX_set_session_cache_mode(this.context.getSSLContext(), mode);
    }

    public boolean isSessionCacheEnabled() {
        return openssl_h_Macros.SSL_CTX_get_session_cache_mode(this.context.getSSLContext()) == (long)openssl_h.SSL_SESS_CACHE_SERVER();
    }

    public OpenSSLSessionStats stats() {
        return this.stats;
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        openssl_h.SSL_CTX_set_timeout(this.context.getSSLContext(), seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)openssl_h.SSL_CTX_get_timeout(this.context.getSSLContext());
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        openssl_h_Macros.SSL_CTX_sess_set_cache_size(this.context.getSSLContext(), size);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)openssl_h_Macros.SSL_CTX_sess_get_cache_size(this.context.getSSLContext());
    }

    public boolean setSessionIdContext(byte[] sidCtx) {
        try (Arena memorySession = Arena.ofConfined();){
            MemorySegment array = memorySession.allocateFrom(ValueLayout.JAVA_BYTE, sidCtx);
            boolean bl = openssl_h.SSL_CTX_set_session_id_context(this.context.getSSLContext(), array, sidCtx.length) == 1;
            return bl;
        }
    }

    private static final class EmptyEnumeration
    implements Enumeration<byte[]> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public byte[] nextElement() {
            throw new NoSuchElementException();
        }
    }
}

