/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import ca.sqlpower.util.SQLPowerUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class HSQLDBDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(HSQLDBDatabaseMetaDataDecorator.class);

    public HSQLDBDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        logger.debug((Object)("Creating index info for " + this.makeKey(catalog, schema, table)));
        ResultSet rs = super.getIndexInfo(catalog, schema, table, unique, approximate);
        CachedRowSet indexInfo = new CachedRowSet();
        indexInfo.populate(rs);
        rs.close();
        rs = null;
        HashMap<String, String> pkNames = new HashMap<String, String>();
        HashMap<String, Set<String>> pkCols = new HashMap<String, Set<String>>();
        TreeSet<String> cols = null;
        rs = super.getPrimaryKeys(catalog, schema, table);
        String cat = null;
        String sch = null;
        String tab = null;
        while (rs.next()) {
            if (SQLPowerUtils.areEqual(cat, rs.getString("TABLE_CAT")) && SQLPowerUtils.areEqual(sch, rs.getString("TABLE_SCHEM")) && SQLPowerUtils.areEqual(tab, rs.getString("TABLE_NAME"))) {
                cols.add(rs.getString("COLUMN_NAME"));
                continue;
            }
            cat = rs.getString("TABLE_CAT");
            sch = rs.getString("TABLE_SCHEM");
            tab = rs.getString("TABLE_NAME");
            String key = this.makeKey(cat, sch, tab);
            pkNames.put(key, rs.getString("PK_NAME"));
            cols = new TreeSet<String>();
            cols.add(rs.getString("COLUMN_NAME"));
            pkCols.put(key, cols);
        }
        rs.close();
        rs = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Discovered PK names: " + pkNames));
            logger.debug((Object)("Discovered PK cols:  " + pkCols));
        }
        Map<String, String> indexToPkName = this.discoverIndexToPKMappings(indexInfo, pkNames, pkCols);
        indexInfo.beforeFirst();
        while (indexInfo.next()) {
            String pkName = indexToPkName.get(indexInfo.getString("INDEX_NAME"));
            if (pkName == null) continue;
            indexInfo.updateString("INDEX_NAME", pkName);
        }
        indexInfo.beforeFirst();
        return indexInfo;
    }

    private Map<String, String> discoverIndexToPKMappings(CachedRowSet indexInfo, Map<String, String> pkNames, Map<String, Set<String>> pkCols) throws SQLException {
        Set<String> colsOfPk;
        String key;
        HashMap<String, String> indexToPKName = new HashMap<String, String>();
        indexInfo.beforeFirst();
        String cat = null;
        String sch = null;
        String tab = null;
        String idx = null;
        TreeSet<String> cols = null;
        while (indexInfo.next()) {
            logger.debug((Object)("Considering index " + indexInfo.getString("INDEX_NAME") + ", col " + indexInfo.getString("COLUMN_NAME")));
            if (indexInfo.getBoolean("NON_UNIQUE") || indexInfo.getInt("TYPE") == 0 || !indexInfo.getString("INDEX_NAME").startsWith("SYS_IDX_")) continue;
            if (SQLPowerUtils.areEqual(cat, indexInfo.getString("TABLE_CAT")) && SQLPowerUtils.areEqual(sch, indexInfo.getString("TABLE_SCHEM")) && SQLPowerUtils.areEqual(tab, indexInfo.getString("TABLE_NAME")) && SQLPowerUtils.areEqual(idx, indexInfo.getString("INDEX_NAME"))) {
                cols.add(indexInfo.getString("COLUMN_NAME"));
                continue;
            }
            key = this.makeKey(cat, sch, tab);
            colsOfPk = pkCols.get(key);
            if (colsOfPk != null && ((Object)colsOfPk).equals(cols)) {
                logger.debug((Object)("Found index name mapping " + idx + " -> " + pkNames.get(key)));
                indexToPKName.put(idx, pkNames.get(key));
                pkNames.remove(key);
            } else {
                logger.debug((Object)("Index is not a PK: " + idx + "(my cols: " + cols + "; colsOfPk: " + colsOfPk + ")"));
            }
            cat = indexInfo.getString("TABLE_CAT");
            sch = indexInfo.getString("TABLE_SCHEM");
            tab = indexInfo.getString("TABLE_NAME");
            idx = indexInfo.getString("INDEX_NAME");
            cols = new TreeSet<String>();
            cols.add(indexInfo.getString("COLUMN_NAME"));
        }
        logger.debug((Object)"Finished main loop. doing final check...");
        key = this.makeKey(cat, sch, tab);
        colsOfPk = pkCols.get(key);
        if (colsOfPk != null && ((Object)colsOfPk).equals(cols)) {
            logger.debug((Object)("Found index name mapping " + idx + " -> " + pkNames.get(key)));
            indexToPKName.put(idx, pkNames.get(key));
            pkNames.remove(key);
        } else {
            logger.debug((Object)("Index is not a PK: " + idx + "(my cols: " + cols + "; colsOfPk: " + colsOfPk + ")"));
        }
        return indexToPKName;
    }

    private String makeKey(String cat, String sch, String tab) {
        String key = cat + "." + sch + "." + tab;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet columns = null;
        try {
            columns = super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            CachedRowSet crs = new CachedRowSet();
            crs.populate(columns);
            while (crs.next()) {
                int type = crs.getInt(5);
                if (type != 4 || crs.getInt(7) != 0) continue;
                crs.updateInt(7, 10);
            }
            crs.beforeFirst();
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close original result set", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new GenericResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new GenericStatementDecorator(this.connectionDecorator, statement);
    }
}

