/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AddPlayerMessage;
import net.sf.freecol.common.networking.AnimateAttackMessage;
import net.sf.freecol.common.networking.AnimateMoveMessage;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ErrorMessage;
import net.sf.freecol.common.networking.FeatureChangeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MultipleMessage;
import net.sf.freecol.common.networking.PartialMessage;
import net.sf.freecol.common.networking.RemoveMessage;
import net.sf.freecol.common.networking.SetAIMessage;
import net.sf.freecol.common.networking.SetStanceMessage;
import net.sf.freecol.common.networking.SpySettlementMessage;
import net.sf.freecol.common.networking.UpdateMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class ChangeSet {
    private final List<Change> changes;

    public ChangeSet() {
        this.changes = new ArrayList<Change>();
    }

    public ChangeSet(ChangeSet other) {
        this.changes = new ArrayList<Change>(other.changes);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public void clear() {
        this.changes.clear();
    }

    public void remove(FreeColGameObject fcgo) {
        CollectionUtils.removeInPlace(this.changes, c -> c.matches(fcgo));
    }

    public ChangeSet add(See see, FreeColGameObject ... objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, Collection<? extends FreeColGameObject> objects) {
        for (FreeColGameObject freeColGameObject : objects) {
            this.changes.add(new ObjectChange(see, freeColGameObject));
        }
        return this;
    }

    public <T extends Message> ChangeSet add(See see, T message) {
        this.changes.add(new MessageChange<T>(see, message));
        return this;
    }

    public ChangeSet addAttack(See see, Unit attacker, Unit defender, boolean success) {
        this.changes.add(new AttackChange(see, attacker, defender, success));
        return this;
    }

    public ChangeSet addAttribute(See see, String key, String value) {
        this.changes.add(new AttributeChange(see, key, value));
        return this;
    }

    public ChangeSet addDisappear(Player owner, Tile tile, FreeColGameObject fcgo) {
        this.changes.add(new RemoveChange(See.perhaps().except(owner), tile, Stream.of(fcgo)));
        this.changes.add(new ObjectChange(See.perhaps().except(owner), tile));
        return this;
    }

    public ChangeSet addAbility(Player player, FreeColGameObject object, Ability ability, boolean add) {
        this.changes.add(new FeatureChange(See.only(player), object, ability, add));
        if (add) {
            object.addAbility(ability);
        } else {
            object.removeAbility(ability);
        }
        return this;
    }

    public ChangeSet addModifier(Player player, FreeColGameObject object, Modifier modifier, boolean add) {
        this.changes.add(new FeatureChange(See.only(player), object, modifier, add));
        if (add) {
            object.addModifier(modifier);
        } else {
            object.removeModifier(modifier);
        }
        return this;
    }

    public ChangeSet addGlobalHistory(Game game, HistoryEvent history) {
        for (Player p : game.getLiveEuropeanPlayerList(new Player[0])) {
            this.addHistory(p, history);
        }
        return this;
    }

    public ChangeSet addGlobalMessage(Game game, Player omit, ModelMessage message) {
        for (Player p : game.getLiveEuropeanPlayerList(new Player[0])) {
            if (p == omit) continue;
            this.addMessage(p, message);
        }
        return this;
    }

    public ChangeSet addHistory(Player player, HistoryEvent history) {
        this.changes.add(new FeatureChange(See.only(player), player, history, true));
        player.addHistory(history);
        return this;
    }

    public ChangeSet addMessage(Player player, ModelMessage message) {
        this.changes.add(new FeatureChange(See.only(player), player, message, true));
        return this;
    }

    public ChangeSet addMove(See see, Unit unit, Location loc, Tile tile) {
        this.changes.add(new MoveChange(see, unit, loc, tile));
        return this;
    }

    public <T extends FreeColGameObject> ChangeSet addPartial(See see, T fcgo, String ... fields) {
        this.changes.add(new PartialObjectChange<T>(see, fcgo, CollectionUtils.asMap(fields)));
        return this;
    }

    public ChangeSet addNewPlayer(Player player) {
        this.changes.add(new PlayerChange(See.all().except(player), Collections.singletonList(player)));
        return this;
    }

    public ChangeSet addPlayers(List<? extends Player> players) {
        this.changes.add(new PlayerChange(See.all(), players));
        return this;
    }

    public ChangeSet addRemove(See see, Location loc, FreeColGameObject obj) {
        this.changes.add(new RemoveChange(see, loc, obj.getDisposables()));
        return this;
    }

    public ChangeSet addRemoves(See see, Location loc, List<? extends FreeColGameObject> objects) {
        for (FreeColGameObject freeColGameObject : objects) {
            this.changes.add(new RemoveChange(see, loc, freeColGameObject.getDisposables()));
        }
        return this;
    }

    public ChangeSet addSale(Player player, Settlement settlement, GoodsType type, int price) {
        Game game = settlement.getGame();
        LastSale sale = new LastSale(settlement, type, game.getTurn(), price);
        this.changes.add(new FeatureChange(See.only(player), player, sale, true));
        player.addLastSale(sale);
        return this;
    }

    public ChangeSet addSpy(Unit unit, Settlement settlement) {
        this.changes.add(new SpyChange(See.only(unit.getOwner()), unit, settlement));
        return this;
    }

    public ChangeSet addStance(See see, Player first, Stance stance, Player second) {
        this.changes.add(new StanceChange(see, first, stance, second));
        return this;
    }

    public void merge(ChangeSet other) {
        this.changes.addAll(other.changes);
    }

    public Message build(Player player) {
        if (this.changes.isEmpty()) {
            return null;
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<Message> diverted = new ArrayList<Message>();
        for (Change c : this.changes) {
            if (!c.isNotifiable(player)) continue;
            Object t = c.toMessage(player);
            ArrayList<Object> onto = ((Message)t).canMerge() ? diverted : messages;
            onto.add(t);
            if ((c = c.consequence(player)) == null) continue;
            Object t2 = c.toMessage(player);
            onto = ((Message)t2).canMerge() ? diverted : messages;
            onto.add(t2);
        }
        messages.sort(Message.messagePriorityComparator);
        diverted.sort(Message.messagePriorityComparator);
        if (messages.size() > 1) {
            ArrayList<Message> more = new ArrayList<Message>();
            Message head = (Message)messages.remove(0);
            while (!messages.isEmpty()) {
                Message message = (Message)messages.remove(0);
                if (head.merge(message)) continue;
                more.add(head);
                head = message;
            }
            more.add(head);
            messages = more;
        }
        MultipleMessage mm = new MultipleMessage(messages);
        mm.setMergeable(true);
        for (Message message : diverted) {
            mm.merge(message);
        }
        return mm.simplify();
    }

    public static ChangeSet clientError(Player player, StringTemplate template) {
        See see = player == null ? See.all() : See.only(player);
        return ChangeSet.clientError(see, template);
    }

    public static ChangeSet clientError(See see, StringTemplate template) {
        ChangeSet cs = new ChangeSet();
        if (see == null) {
            see = See.all();
        }
        cs.add(see, new ErrorMessage(template));
        return cs;
    }

    public static ChangeSet clientError(Player player, String message) {
        See see = player == null ? See.all() : See.only(player);
        return ChangeSet.clientError(see, message);
    }

    public static ChangeSet clientError(See see, String message) {
        ChangeSet cs = new ChangeSet();
        if (see == null) {
            see = See.all();
        }
        cs.add(see, new ErrorMessage(message));
        return cs;
    }

    public static ChangeSet simpleChange(Player player, Message message) {
        See see = player == null ? See.all() : See.only(player);
        return ChangeSet.simpleChange(see, message);
    }

    public static ChangeSet simpleChange(See see, Message message) {
        ChangeSet cs = new ChangeSet();
        cs.add(see == null ? See.all() : see, message);
        return cs;
    }

    public static ChangeSet aiChange(Player player, boolean ai) {
        return ChangeSet.simpleChange(See.all(), (Message)new SetAIMessage(player, ai));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Change c : this.changes) {
            sb.append(c).append('\n');
        }
        return sb.toString();
    }

    private static class StanceChange
    extends Change<SetStanceMessage> {
        private final Player first;
        private final Stance stance;
        private final Player second;

        public StanceChange(See see, Player first, Stance stance, Player second) {
            super(see);
            this.first = first;
            this.stance = stance;
            this.second = second;
        }

        @Override
        public SetStanceMessage toMessage(Player player) {
            return !this.isNotifiable(player) ? null : new SetStanceMessage(this.stance, this.first, this.second);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.first.getId()).append(' ').append(this.stance).append(' ').append(this.second.getId()).append(']');
            return sb.toString();
        }
    }

    private static class SpyChange
    extends Change<SpySettlementMessage> {
        private final Unit unit;
        private final Settlement settlement;

        public SpyChange(See see, Unit unit, Settlement settlement) {
            super(see);
            this.unit = unit;
            this.settlement = settlement;
        }

        @Override
        public SpySettlementMessage toMessage(Player player) {
            return !this.isNotifiable(player) ? null : new SpySettlementMessage(this.unit, this.settlement);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.settlement.getId()).append(']');
            return sb.toString();
        }
    }

    private static class RemoveChange
    extends Change<RemoveMessage> {
        private final Tile tile;
        private final List<? extends FreeColGameObject> contents;

        public RemoveChange(See see, Location loc, Stream<? extends FreeColGameObject> objects) {
            super(see);
            this.tile = loc instanceof Tile ? (Tile)loc : null;
            this.contents = CollectionUtils.toList(objects);
        }

        private FreeColGameObject getMainObject() {
            return this.contents.get(this.contents.size() - 1);
        }

        private boolean fullRemoval(Player player) {
            FreeColGameObject fcgo = this.getMainObject();
            return fcgo instanceof Ownable && player.owns((Ownable)((Object)fcgo));
        }

        @Override
        public boolean isNotifiable(Player player) {
            Settlement settlement;
            switch (this.check(player)) {
                case VISIBLE: {
                    return true;
                }
                case INVISIBLE: {
                    return false;
                }
            }
            return this.tile != null && player.canSee(this.tile) && ((settlement = this.tile.getSettlement()) == null || settlement.isDisposed() || player.owns(settlement));
        }

        @Override
        public RemoveMessage toMessage(Player player) {
            String divertId = this.tile != null ? this.tile.getId() : player.getId();
            return new RemoveMessage(divertId, this.fullRemoval(player) ? this.contents : Collections.singletonList(this.getMainObject()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.tile == null ? "<null>" : this.tile.getId());
            for (FreeColGameObject freeColGameObject : this.contents) {
                sb.append(' ').append(freeColGameObject.getId());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static class PlayerChange
    extends Change<AddPlayerMessage> {
        private final List<Player> players = new ArrayList<Player>();

        public PlayerChange(See see, List<? extends Player> newPlayers) {
            super(see);
            this.players.clear();
            this.players.addAll(newPlayers);
        }

        @Override
        public AddPlayerMessage toMessage(Player player) {
            if (!this.isNotifiable(player)) {
                return null;
            }
            return new AddPlayerMessage(player, this.players);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see);
            for (Player p : this.players) {
                sb.append(' ').append(p.getId());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static class PartialObjectChange<T extends FreeColGameObject>
    extends Change<PartialMessage> {
        private final Map<String, String> map;

        public PartialObjectChange(See see, T fcgo, Map<String, String> map) {
            super(see);
            this.map = map;
            this.map.put("id", ((FreeColObject)fcgo).getId());
        }

        @Override
        public PartialMessage toMessage(Player player) {
            return new PartialMessage(this.map);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see);
            for (Map.Entry<String, String> e : this.map.entrySet()) {
                sb.append(' ').append(e.getKey()).append('=').append(e.getValue());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static class ObjectChange
    extends Change<UpdateMessage> {
        protected final FreeColGameObject fcgo;

        public ObjectChange(See see, FreeColGameObject fcgo) {
            super(see);
            this.fcgo = fcgo;
        }

        @Override
        public boolean matches(FreeColGameObject fcgo) {
            return this.fcgo == fcgo;
        }

        @Override
        public boolean isNotifiable(Player player) {
            switch (this.check(player)) {
                case VISIBLE: {
                    return true;
                }
                case INVISIBLE: {
                    return false;
                }
            }
            if (this.fcgo == null) {
                return false;
            }
            if (this.fcgo instanceof Unit) {
                return player.canSeeUnit((Unit)this.fcgo);
            }
            if (this.fcgo instanceof Ownable && player.owns((Ownable)((Object)this.fcgo))) {
                return true;
            }
            if (this.fcgo instanceof WorkLocation) {
                return false;
            }
            if (this.fcgo instanceof Location) {
                Tile tile = ((Location)((Object)this.fcgo)).getTile();
                return player.canSee(tile);
            }
            return false;
        }

        @Override
        public UpdateMessage toMessage(Player player) {
            return !this.isNotifiable(player) ? null : new UpdateMessage(player, Collections.singletonList(this.fcgo));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.fcgo == null ? "<null>" : this.fcgo.getId()).append(']');
            return sb.toString();
        }
    }

    private static class MoveChange
    extends Change<AnimateMoveMessage> {
        private final Unit unit;
        private final Location oldLocation;
        private final Tile newTile;

        public MoveChange(See see, Unit unit, Location oldLocation, Tile newTile) {
            super(see);
            this.unit = unit;
            this.oldLocation = oldLocation;
            this.newTile = newTile;
        }

        private boolean seeOld(Player player) {
            Tile oldTile = this.oldLocation.getTile();
            return player.owns(this.unit) || oldTile != null && player.canSee(oldTile) && !oldTile.hasSettlement() && !(this.oldLocation instanceof Unit);
        }

        private boolean seeNew(Player player) {
            return player.canSeeUnit(this.unit);
        }

        @Override
        public boolean isNotifiable(Player player) {
            if (player.isAI()) {
                return false;
            }
            switch (this.check(player)) {
                case VISIBLE: {
                    return true;
                }
                case INVISIBLE: {
                    return false;
                }
            }
            return this.seeOld(player) || this.seeNew(player);
        }

        @Override
        public Change consequence(Player player) {
            return this.seeOld(player) && !this.seeNew(player) && !this.unit.isDisposed() ? new RemoveChange(See.only(player), this.unit.getLocation(), Stream.of(this.unit)) : null;
        }

        @Override
        public AnimateMoveMessage toMessage(Player player) {
            if (!this.isNotifiable(player)) {
                return null;
            }
            Tile oldTile = this.oldLocation.getTile();
            Unit u = player.owns(this.unit) ? this.unit : this.unit.reduceVisibility(this.oldLocation.getTile(), player);
            return new AnimateMoveMessage(u, oldTile, this.newTile, !this.seeOld(player));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.unit.getId()).append(' ').append(this.oldLocation.getId()).append(' ').append(this.newTile.getId()).append(']');
            return sb.toString();
        }
    }

    private static class MessageChange<T extends Message>
    extends Change<T> {
        private final T message;

        public MessageChange(See see, T message) {
            super(see);
            this.message = message;
        }

        @Override
        public T toMessage(Player player) {
            return this.isNotifiable(player) ? (T)this.message : null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(StringUtils.lastPart(this.getClass().getName(), ".")).append(' ').append(this.see).append(' ').append(this.message).append(']');
            return sb.toString();
        }
    }

    private static class FeatureChange
    extends Change<FeatureChangeMessage> {
        private final FreeColGameObject parent;
        private final FreeColObject child;
        private final boolean add;

        public FeatureChange(See see, FreeColGameObject parent, FreeColObject child, boolean add) {
            super(see);
            this.parent = parent;
            this.child = child;
            this.add = add;
        }

        @Override
        public boolean isNotifiable(Player player) {
            return this.check(player) == SeeCheck.VISIBLE;
        }

        @Override
        public FeatureChangeMessage toMessage(Player player) {
            return !this.isNotifiable(player) ? null : new FeatureChangeMessage(this.parent, this.child, this.add);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.add ? "add" : "remove").append(' ').append(this.child).append(' ').append(this.add ? "to" : "from").append(' ').append(this.parent.getId()).append(']');
            return sb.toString();
        }
    }

    private static class AttributeChange
    extends Change<AttributeMessage> {
        private final String key;
        private final String value;

        public AttributeChange(See see, String key, String value) {
            super(see);
            this.key = key;
            this.value = value;
        }

        @Override
        public AttributeMessage toMessage(Player player) {
            return new AttributeMessage("attribute", this.key, this.value).setMergeable(true);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.key).append('=').append(this.value).append(']');
            return sb.toString();
        }
    }

    private static class AttackChange
    extends Change<AnimateAttackMessage> {
        private final Unit attacker;
        private final Unit defender;
        private final boolean success;
        private final boolean defenderInSettlement;

        public AttackChange(See see, Unit attacker, Unit defender, boolean success) {
            super(see);
            Game game = attacker.getGame();
            this.attacker = attacker.copy(game, Unit.class);
            this.defender = defender.copy(game, Unit.class);
            this.success = success;
            this.defenderInSettlement = defender.getTile().hasSettlement();
        }

        private boolean attackerVisible(Player player) {
            return player.canSeeUnit(this.attacker);
        }

        private boolean defenderVisible(Player player) {
            return player.canSeeUnit(this.defender) && (!this.defenderInSettlement || player.owns(this.defender));
        }

        @Override
        public boolean isNotifiable(Player player) {
            switch (this.check(player)) {
                case VISIBLE: {
                    return true;
                }
                case INVISIBLE: {
                    return false;
                }
            }
            return player.owns(this.attacker) || player.owns(this.defender) || player.canSee(this.attacker.getTile()) && player.canSee(this.defender.getTile());
        }

        @Override
        public AnimateAttackMessage toMessage(Player player) {
            if (!this.isNotifiable(player)) {
                return null;
            }
            Unit a = player.owns(this.attacker) ? this.attacker : this.attacker.reduceVisibility(this.attacker.getTile(), player);
            Unit d = player.owns(this.defender) ? this.defender : this.defender.reduceVisibility(this.defender.getTile(), player);
            return new AnimateAttackMessage(a, d, this.success, !this.attackerVisible(player), !this.defenderVisible(player));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append('[').append(this.getClass().getName()).append(' ').append(this.see).append(' ').append(this.attacker.getId()).append('@').append(this.attacker.getTile().getId()).append(' ').append(this.success).append(' ').append(this.defender.getId()).append('@').append(this.defender.getTile().getId()).append(']');
            return sb.toString();
        }
    }

    public static abstract class Change<T extends Message> {
        protected final See see;

        public Change(See see) {
            this.see = see;
        }

        protected SeeCheck check(Player player) {
            return this.see.check(player);
        }

        public boolean matches(FreeColGameObject fcgo) {
            return false;
        }

        public boolean isNotifiable(Player player) {
            return this.check(player) == SeeCheck.VISIBLE;
        }

        public Change consequence(Player player) {
            return null;
        }

        public abstract T toMessage(Player var1);
    }

    public static class See {
        private static final int ALL = 1;
        private static final int PERHAPS = 0;
        private static final int ONLY = -1;
        private Player seeAlways = null;
        private Player seePerhaps = null;
        private Player seeNever = null;
        private final int type;

        private See(int type) {
            this.type = type;
        }

        public SeeCheck check(Player player) {
            return player != null && player == this.seeNever ? SeeCheck.INVISIBLE : (player != null && player == this.seeAlways ? SeeCheck.VISIBLE : (player != null && player == this.seePerhaps ? SeeCheck.SPECIAL : (this.type == -1 ? SeeCheck.INVISIBLE : (this.type == 1 ? SeeCheck.VISIBLE : SeeCheck.SPECIAL))));
        }

        public static See all() {
            return new See(1);
        }

        public static See perhaps() {
            return new See(0);
        }

        public static See only(Player player) {
            return new See(-1).always(player);
        }

        public See always(Player player) {
            this.seeAlways = player;
            return this;
        }

        public See perhapsOnly(Player player) {
            this.seePerhaps = player;
            return this;
        }

        public See except(Player player) {
            this.seeNever = player;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.type == 1 ? "ALL" : (this.type == 0 ? "PERHAPS" : (this.type == -1 ? "ONLY" : "BADTYPE")));
            if (this.seeAlways != null) {
                sb.append(",always(").append(this.seeAlways.getId()).append(')');
            }
            if (this.seePerhaps != null) {
                sb.append(",perhaps(").append(this.seePerhaps.getId()).append(')');
            }
            if (this.seeNever != null) {
                sb.append(",never(").append(this.seeNever.getId()).append(')');
            }
            return sb.toString();
        }
    }

    private static enum SeeCheck {
        VISIBLE,
        INVISIBLE,
        SPECIAL;

    }
}

