/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.cgi.escape;

import org.jcodings.Encoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public class CGIEscape
implements Library {
    public static final String ACCEPT_CHARSET = "@@accept_charset";
    public static final byte[] NO39 = "&#39;".getBytes(RubyEncoding.UTF8);
    public static final byte[] AMP = "&amp;".getBytes(RubyEncoding.UTF8);
    public static final byte[] QUOT = "&quot;".getBytes(RubyEncoding.UTF8);
    public static final byte[] LT = "&lt;".getBytes(RubyEncoding.UTF8);
    public static final byte[] GT = "&gt;".getBytes(RubyEncoding.UTF8);
    public static final int UNICODE_MAX = 0x10FFFF;
    public static final byte[] TSEMI = "t;".getBytes(RubyEncoding.UTF8);
    public static final byte[] UOTSEMI = "uot;".getBytes(RubyEncoding.UTF8);
    public static final byte[] MPSEMI = "mp;".getBytes(RubyEncoding.UTF8);
    public static final byte[] POSSEMI = "pos;".getBytes(RubyEncoding.UTF8);
    static final byte[] upper_hexdigits = "0123456789ABCDEF".getBytes(RubyEncoding.UTF8);
    private static final int[] ruby_digit36_to_number_table = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    static void html_escaped_cat(RubyString rubyString, byte by) {
        switch (by) {
            case 39: {
                rubyString.cat(NO39);
                break;
            }
            case 38: {
                rubyString.cat(AMP);
                break;
            }
            case 34: {
                rubyString.cat(QUOT);
                break;
            }
            case 60: {
                rubyString.cat(LT);
                break;
            }
            case 62: {
                rubyString.cat(GT);
            }
        }
    }

    static void preserve_original_state(RubyString rubyString, RubyString rubyString2) {
        rubyString2.setEncoding(rubyString.getEncoding());
        rubyString2.infectBy((IRubyObject)rubyString);
    }

    static IRubyObject optimized_escape_html(Ruby ruby, RubyString rubyString) {
        int n = 0;
        RubyString rubyString2 = null;
        int n2 = rubyString.size();
        ByteList byteList = rubyString.getByteList();
        byte[] byArray = byteList.unsafeBytes();
        int n3 = byteList.begin();
        for (int i = 0; i < n2; ++i) {
            switch (byArray[n3 + i]) {
                case 34: 
                case 38: 
                case 39: 
                case 60: 
                case 62: {
                    if (rubyString2 == null) {
                        rubyString2 = RubyString.newStringLight((Ruby)ruby, (int)n2);
                    }
                    rubyString2.cat(byArray, n3 + n, i - n);
                    n = i + 1;
                    CGIEscape.html_escaped_cat(rubyString2, byArray[n3 + i]);
                }
            }
        }
        if (rubyString2 != null) {
            rubyString2.cat(byArray, n3 + n, n2 - n);
            CGIEscape.preserve_original_state(rubyString, rubyString2);
            return rubyString2;
        }
        return rubyString.strDup(ruby);
    }

    static boolean MATCH(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return n - n2 >= byArray.length && ByteList.memcmp((byte[])byArray2, (int)(n3 + n2), (byte[])byArray, (int)0, (int)byArray.length) == 0;
    }

    static IRubyObject optimized_unescape_html(Ruby ruby, RubyString rubyString) {
        Encoding encoding = rubyString.getEncoding();
        int n = encoding instanceof UTF8Encoding ? 0x10FFFF : (encoding instanceof ISO8859_1Encoding ? 256 : 128);
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        byte[] byArray = new byte[6];
        RubyString rubyString2 = null;
        int n4 = rubyString.size();
        ByteList byteList = rubyString.getByteList();
        byte[] byArray2 = byteList.getUnsafeBytes();
        int n5 = byteList.begin();
        block7: for (int i = 0; i < n4; ++i) {
            int n6 = byArray2[n5 + i];
            if (n6 != 38) continue;
            int n7 = i - n2;
            if (++i >= n4) break;
            n6 = byArray2[n5 + i] & 0xFF;
            int n8 = i++;
            switch (n6) {
                case 97: {
                    if (CGIEscape.MATCH(POSSEMI, n4, i, byArray2, n5)) {
                        i += POSSEMI.length - 1;
                        n6 = 39;
                        break;
                    }
                    if (CGIEscape.MATCH(MPSEMI, n4, i, byArray2, n5)) {
                        i += MPSEMI.length - 1;
                        n6 = 38;
                        break;
                    }
                    i = n8;
                    continue block7;
                }
                case 113: {
                    if (CGIEscape.MATCH(UOTSEMI, n4, ++i, byArray2, n5)) {
                        i += UOTSEMI.length - 1;
                        n6 = 34;
                        break;
                    }
                    i = n8;
                    continue block7;
                }
                case 103: {
                    if (CGIEscape.MATCH(TSEMI, n4, ++i, byArray2, n5)) {
                        i += TSEMI.length - 1;
                        n6 = 62;
                        break;
                    }
                    i = n8;
                    continue block7;
                }
                case 108: {
                    if (CGIEscape.MATCH(TSEMI, n4, ++i, byArray2, n5)) {
                        i += TSEMI.length - 1;
                        n6 = 60;
                        break;
                    }
                    i = n8;
                    continue block7;
                }
                case 35: {
                    int n9;
                    int[] nArray;
                    if (n4 - ++i >= 2 && Character.isDigit(byArray2[n5 + i])) {
                        nArray = new int[]{n3, bl ? 1 : 0};
                        n9 = CGIEscape.ruby_scan_digits(byArray2, n5 + i, n4 - i, 10, nArray);
                        n3 = nArray[0];
                        bl = nArray[1] == 1;
                    } else if (i < n4 && (byArray2[n5 + i] == 120 || byArray2[n5 + i] == 88) && n4 - ++i >= 2 && CGIEscape.ISXDIGIT(byArray2, n5 + i)) {
                        nArray = new int[]{n3, bl ? 1 : 0};
                        n9 = CGIEscape.ruby_scan_digits(byArray2, n5 + i, n4 - i, 16, nArray);
                        n3 = nArray[0];
                        bl = nArray[1] == 1;
                    } else {
                        i = n8;
                        continue block7;
                    }
                    if (bl || n9 >= n || (i += n3) >= n4 || byArray2[n5 + i] != 59) {
                        i = n8;
                        continue block7;
                    }
                    if (rubyString2 == null) {
                        rubyString2 = RubyString.newStringLight((Ruby)ruby, (int)n4);
                    }
                    rubyString2.cat(byArray2, n5 + n2, n7);
                    if (n > 256) {
                        rubyString2.cat(byArray, 0, encoding.codeToMbc(n9, byArray, 0));
                    } else {
                        n6 = n9;
                        rubyString2.cat(n6);
                    }
                    n2 = i + 1;
                    continue block7;
                }
                default: {
                    --i;
                    continue block7;
                }
            }
            if (rubyString2 == null) {
                rubyString2 = RubyString.newStringLight((Ruby)ruby, (int)n4);
            }
            rubyString2.cat(byArray2, n5 + n2, n7);
            rubyString2.cat(n6);
            n2 = i + 1;
        }
        if (rubyString2 != null) {
            rubyString2.cat(byArray2, n5 + n2, n4 - n2);
            CGIEscape.preserve_original_state(rubyString, rubyString2);
            return rubyString2;
        }
        return rubyString.strDup(ruby);
    }

    static boolean ISXDIGIT(byte[] byArray, int n) {
        byte by = byArray[n];
        return by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70;
    }

    static boolean url_unreserved_char(int n) {
        switch (n) {
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    static IRubyObject optimized_escape(Ruby ruby, RubyString rubyString, boolean bl) {
        int n = 0;
        RubyString rubyString2 = null;
        byte[] byArray = new byte[]{37, 0, 0};
        int n2 = rubyString.size();
        ByteList byteList = rubyString.getByteList();
        byte[] byArray2 = byteList.unsafeBytes();
        int n3 = byteList.begin();
        for (int i = 0; i < n2; ++i) {
            int n4 = byArray2[n3 + i] & 0xFF;
            if (CGIEscape.url_unreserved_char(n4)) continue;
            if (rubyString2 == null) {
                rubyString2 = RubyString.newStringLight((Ruby)ruby, (int)n2);
            }
            rubyString2.cat(byArray2, n3 + n, i - n);
            n = i + 1;
            if (bl && n4 == 32) {
                rubyString2.cat(43);
                continue;
            }
            byArray[1] = upper_hexdigits[n4 >> 4 & 0xF];
            byArray[2] = upper_hexdigits[n4 & 0xF];
            rubyString2.cat(byArray, 0, 3);
        }
        if (rubyString2 != null) {
            rubyString2.cat(byArray2, n3 + n, n2 - n);
            CGIEscape.preserve_original_state(rubyString, rubyString2);
            return rubyString2;
        }
        return rubyString.strDup(ruby);
    }

    static IRubyObject optimized_unescape(ThreadContext threadContext, RubyString rubyString, IRubyObject iRubyObject, boolean bl) {
        int n;
        int n2 = 0;
        RubyString rubyString2 = null;
        Encoding encoding = EncodingUtils.rbToEncoding((ThreadContext)threadContext, (IRubyObject)iRubyObject);
        int n3 = rubyString.size();
        ByteList byteList = rubyString.getByteList();
        byte[] byArray = byteList.unsafeBytes();
        int n4 = byteList.begin();
        int n5 = 0;
        Ruby ruby = threadContext.runtime;
        for (int i = 0; i < n3; ++i) {
            int n6 = byArray[n4 + i] & 0xFF;
            int n7 = 0;
            if (n6 == 37) {
                if (i + 3 > n3) break;
                if (!CGIEscape.ISXDIGIT(byArray, n4 + i + 1) || !CGIEscape.ISXDIGIT(byArray, n4 + i + 2)) continue;
                n5 = CGIEscape.char_to_number(byArray[n4 + i + 1]) << 4 | CGIEscape.char_to_number(byArray[n4 + i + 2]);
                n7 = 2;
            } else {
                if (!bl || n6 != 43) continue;
                n5 = 32;
            }
            if (rubyString2 == null) {
                rubyString2 = RubyString.newStringLight((Ruby)ruby, (int)n3);
            }
            rubyString2.cat(byArray, n4 + n2, i - n2);
            n2 = (i += n7) + 1;
            rubyString2.cat(n5);
        }
        if (rubyString2 != null) {
            rubyString2.cat(byArray, n4 + n2, n3 - n2);
            CGIEscape.preserve_original_state(rubyString, rubyString2);
            n = 0;
        } else {
            rubyString2 = rubyString.strDup(ruby);
            n = rubyString.getCodeRange();
        }
        Encoding encoding2 = rubyString.getEncoding();
        if (encoding2 != encoding) {
            rubyString2.setEncoding(encoding);
            if (StringSupport.encCoderangeClean((int)rubyString2.getCodeRange()) == 0) {
                rubyString2.setEncoding(encoding2);
                if (n != 0) {
                    rubyString2.setCodeRange(n);
                }
            }
        }
        return rubyString2;
    }

    @JRubyMethod(name={"escapeHTML"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape_html(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape_html(threadContext.runtime, rubyString);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (Block)Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unescapeHTML"}, module=true, frame=true)
    public static IRubyObject cgiesc_unescape_html(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_unescape_html(threadContext.runtime, rubyString);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (Block)Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"escape"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape(threadContext.runtime, rubyString, true);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (Block)Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"escapeURIComponent"}, alias={"escape_uri_component"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape_uri_component(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape(threadContext.runtime, rubyString, false);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (Block)Block.NULL_BLOCK);
    }

    static IRubyObject accept_charset(IRubyObject[] iRubyObjectArray, int n, int n2, IRubyObject iRubyObject) {
        if (n > 0) {
            return iRubyObjectArray[n2];
        }
        return iRubyObject.getMetaClass().getClassVar(ACCEPT_CHARSET);
    }

    @JRubyMethod(name={"unescape"}, required=1, optional=1, module=true, frame=true)
    public static IRubyObject cgiesc_unescape(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            IRubyObject iRubyObject3 = CGIEscape.accept_charset(iRubyObjectArray, iRubyObjectArray.length - 1, 1, iRubyObject);
            return CGIEscape.optimized_unescape(threadContext, rubyString, iRubyObject3, true);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray, (Block)Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unescapeURIComponent"}, alias={"unescape_uri_component"}, required=1, optional=1, module=true, frame=true)
    public static IRubyObject cgiesc_unescape_uri_component(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getEncoding().isAsciiCompatible()) {
            IRubyObject iRubyObject3 = CGIEscape.accept_charset(iRubyObjectArray, iRubyObjectArray.length - 1, 1, iRubyObject);
            return CGIEscape.optimized_unescape(threadContext, rubyString, iRubyObject3, false);
        }
        return Helpers.invokeSuper((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray, (Block)Block.NULL_BLOCK);
    }

    public void load(Ruby ruby, boolean bl) {
        RubyClass rubyClass = ruby.defineClass("CGI", ruby.getObject(), ruby.getObject().getAllocator());
        RubyModule rubyModule = rubyClass.defineModuleUnder("Escape");
        RubyModule rubyModule2 = rubyClass.defineModuleUnder("Util");
        rubyModule.defineAnnotatedMethods(CGIEscape.class);
        rubyModule2.prependModule(rubyModule);
        rubyModule.extend_object((IRubyObject)rubyClass);
    }

    static int ruby_scan_digits(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        int n4 = n;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE / n3;
        nArray[1] = 0;
        if (n2 == 0) {
            nArray[0] = 0;
            return 0;
        }
        do {
            int n7;
            int n8;
            if ((n8 = ruby_digit36_to_number_table[byArray[n++]]) == -1 || n3 <= n8) {
                --n;
                break;
            }
            if (n6 < n5) {
                nArray[1] = 1;
            }
            n5 *= n3;
            if ((n5 += n8) >= (n7 = n5)) continue;
            nArray[1] = 1;
        } while (n2 < 0 || --n2 != 0);
        nArray[0] = n - n4;
        return n5;
    }

    static int char_to_number(int n) {
        return ruby_digit36_to_number_table[n];
    }
}

