/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource;

import org.graalvm.visualvm.gotosource.Bundle;

public abstract class SourceHandle {
    public static final SourceHandle EMPTY = new Empty();
    private static final String FILE_PREFIX = "file:///";

    public abstract String getLanguage();

    public abstract String getClassName();

    public abstract String getMethodName();

    public abstract String getMethodSignature();

    public abstract int getLine();

    public abstract int getColumn();

    public abstract int getOffset();

    public int getEndOffset() {
        return this.getOffset();
    }

    public abstract String getText();

    public abstract String getSourceUri();

    public abstract String getSourceFile();

    public final String expandFeatures(String command) {
        String code;
        String lang = Feature.LANGUAGE.getCode();
        int index = command.indexOf(lang);
        if (index > -1) {
            command = command.replace(lang, this.getLanguage());
        }
        if ((index = command.indexOf(code = Feature.CLASS.getCode())) > -1) {
            command = command.replace(code, this.getClassName());
        }
        if ((index = command.indexOf(code = Feature.METHOD.getCode())) > -1) {
            command = command.replace(code, this.getMethodName());
        }
        if ((index = command.indexOf(code = Feature.SIGNATURE.getCode())) > -1) {
            command = command.replace(code, this.getMethodSignature());
        }
        if ((index = command.indexOf(code = Feature.LINE.getCode())) > -1) {
            command = command.replace(code, Integer.toString(this.getLine()));
        }
        if ((index = command.indexOf(code = Feature.COLUMN.getCode())) > -1) {
            command = command.replace(code, Integer.toString(this.getColumn()));
        }
        if ((index = command.indexOf(code = Feature.OFFSET.getCode())) > -1) {
            command = command.replace(code, Integer.toString(this.getOffset()));
        }
        if ((index = command.indexOf(code = Feature.TEXT.getCode())) > -1) {
            command = command.replace(code, this.getText());
        }
        if ((index = command.indexOf(code = Feature.URI.getCode())) > -1) {
            command = command.replace(code, this.getSourceUri());
        }
        if ((index = command.indexOf(code = Feature.FILE.getCode())) > -1) {
            command = command.replace(code, this.getSourceFile());
        }
        return command;
    }

    protected abstract void close();

    public static String simpleUri(String uri) {
        int fileIndex = uri.indexOf(FILE_PREFIX);
        return fileIndex == -1 ? uri : uri.substring(fileIndex + FILE_PREFIX.length());
    }

    private static final class Empty
    extends SourceHandle {
        private Empty() {
        }

        @Override
        public String getLanguage() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getClassName() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getMethodName() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getMethodSignature() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int getLine() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int getColumn() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int getOffset() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getSourceUri() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getSourceFile() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        protected void close() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static enum Feature {
        LANGUAGE("{lang}", Bundle.SourceHandle_Language()){}
        ,
        CLASS("{class}", Bundle.SourceHandle_ClassName()){}
        ,
        METHOD("{method}", Bundle.SourceHandle_MethodName()){}
        ,
        SIGNATURE("{sig}", Bundle.SourceHandle_MethodSignature()){}
        ,
        LINE("{line}", Bundle.SourceHandle_SourceLine()){}
        ,
        COLUMN("{column}", Bundle.SourceHandle_SourceColumn()){}
        ,
        OFFSET("{offset}", Bundle.SourceHandle_SourceOffset()){}
        ,
        TEXT("{text}", Bundle.SourceHandle_SourceText()){}
        ,
        URI("{uri}", Bundle.SourceHandle_SourceUri()){}
        ,
        FILE("{file}", Bundle.SourceHandle_SourceFile()){};

        private final String code;
        private final String name;

        private Feature(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

