/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.SocketPortAllocation;
import org.pentaho.di.www.TransformationMap;

public class AllocateServerSocketServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/allocateSocket";
    public static final String PARAM_RANGE_START = "rangeStart";
    public static final String PARAM_HOSTNAME = "host";
    public static final String PARAM_TRANSFORMATION_NAME = "trans";
    public static final String PARAM_SOURCE_SLAVE = "sourceSlave";
    public static final String PARAM_SOURCE_STEPNAME = "sourceStep";
    public static final String PARAM_SOURCE_STEPCOPY = "sourceCopy";
    public static final String PARAM_TARGET_SLAVE = "targetSlave";
    public static final String PARAM_TARGET_STEPNAME = "targetStep";
    public static final String PARAM_TARGET_STEPCOPY = "targetCopy";
    public static final String XML_TAG_PORT = "port";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;

    public AllocateServerSocketServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Reservation of port number of step requested", new Object[0]);
        }
        response.setStatus(200);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        String rangeStart = request.getParameter(PARAM_RANGE_START);
        String hostname = request.getParameter(PARAM_HOSTNAME);
        String transName = request.getParameter(PARAM_TRANSFORMATION_NAME);
        String sourceSlaveName = request.getParameter(PARAM_SOURCE_SLAVE);
        String sourceStepName = request.getParameter(PARAM_SOURCE_STEPNAME);
        String sourceStepCopy = request.getParameter(PARAM_SOURCE_STEPCOPY);
        String targetSlaveName = request.getParameter(PARAM_TARGET_SLAVE);
        String targetStepName = request.getParameter(PARAM_TARGET_STEPNAME);
        String targetStepCopy = request.getParameter(PARAM_TARGET_STEPCOPY);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html");
        }
        SocketPortAllocation port = this.transformationMap.allocateServerSocketPort(Const.toInt((String)rangeStart, (int)40000), hostname, transName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        if (useXML) {
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            out.print(XMLHandler.addTagValue((String)XML_TAG_PORT, (int)port.getPort()));
        } else {
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Allocation of a server socket port number</TITLE></HEAD>");
            out.println("<BODY>");
            out.println("<H1>Status</H1>");
            out.println("<p>");
            out.println("Host name : " + hostname + "<br>");
            out.println("Transformation name : " + transName + "<br>");
            out.println("Source step : " + sourceStepName + "." + sourceStepCopy + "<br>");
            out.println("Target step : " + targetStepName + "." + targetStepCopy + "<br>");
            out.println("Step copy: " + sourceStepCopy + "<br>");
            out.println("<p>");
            out.println("--> port : " + port + "<br>");
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Servet socket port number reservation request";
    }
}

